% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networks.r
\name{filter_window}
\alias{filter_window}
\title{Filter edges from the document similarity network based on hour difference}
\usage{
filter_window(g, hour_window, to_vertices = NULL, from_vertices = NULL)
}
\arguments{
\item{g}{A document similarity network, as created with \link[RNewsflow]{newsflow_compare} or \link[RNewsflow]{create_document_network}}

\item{hour_window}{A vector of length 2, in which the first and second value determine the left and right side of the window, respectively. For example, c(-10, 36) will compare each document to all documents between the previous 10 and the next 36 hours.}

\item{to_vertices}{A filter to select the vertices `to` which an edge is filtered. 
For example, if `V(g)$sourcetype == "newspaper"` is used, then the hour_window filter is only applied for edges `to` newspaper documents (specifically, where the sourcetype attribute is "newspaper").}

\item{from_vertices}{A filter to select the vertices `from` which an edge is filtered. 
Works identical to `to_vertices`.}
}
\value{
A network/graph in the \link[igraph]{igraph} class
}
\description{
The `filter_window` function can be used to filter the document pairs (i.e. edges) using the `hour_window` parameter, which works identical to the `hour_window` parameter in the `newsflow_compare` function. 
In addition, the `from_vertices` and `to_vertices` parameters can be used to select the vertices (i.e. documents) for which this filter is applied.
}
\details{
It is recommended to use the \link[RNewsflow]{show_window} function to verify whether the hour windows are correct according to the assumptions and focus of the study.
}
\examples{
data(docnet)
show_window(docnet, to_attribute = 'source') # before filtering

docnet = filter_window(docnet, hour_window = c(0.1,24))

docnet = filter_window(docnet, hour_window = c(6,36), 
                       to_vertices = V(docnet)$sourcetype == 'Print NP')

show_window(docnet, to_attribute = 'sourcetype') # after filtering per sourcetype
show_window(docnet, to_attribute = 'source') # after filtering per source
}
