% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_omdb_item_languages.R
\name{get_omdb_item_languages}
\alias{get_omdb_item_languages}
\title{Get OMDB Item Languages}
\usage{
get_omdb_item_languages(omdb_id, API_KEY = Sys.getenv("API_KEY"))
}
\arguments{
\item{omdb_id}{String with the omdb_id for a movie/series.}

\item{API_KEY}{OMBD Api Key. Default: Get the Api Key from system environment. Use Sys.setenv('API_KEY' = 'XXXXX'). More information in: http://www.omdbapi.com/apikey.aspx}
}
\value{
Return a vector with the languages of a movie/series.
}
\description{
This function returns a vector with the languages returned by the api (separated by commas).
}
\examples{
\dontrun{
get_omdb_item_languages(omdb_id = 'tt0120338')
}
}
\author{
Alberto Almuiña
}
