% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{get_clustered_eps}
\alias{get_clustered_eps}
\title{Calculate residuals restricted under H0}
\usage{
get_clustered_eps(model, clustering)
}
\arguments{
\item{model}{A regression \code{model}. See \link{example_model} for details.}

\item{clustering}{A \code{List} that specifies a clustering of indexes 1...n (#datapoints).
See \link{example_clustering} for details.}
}
\value{
A \code{List} of the restricted residuals clustered according to \code{clustering}.
}
\description{
Given regression \code{model} and \code{clustering}, this function calculates the OLS residuals
under the linear null hypothesis, and assigns them to the specified clusters.
}
\examples{
m = example_model(n=100)
cl = list(1:50, 51:100)
er = get_clustered_eps(m, cl)
stopifnot(length(er) == length(cl))
stopifnot(length(er[[1]]) == 50)
}
