% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overfitPGLS.R
\name{overfitPGLS}
\alias{overfitPGLS}
\title{Testing PGLS_fossil overfit}
\usage{
overfitPGLS(modform,oveRR=NULL,phylo.list=NULL,data=NULL,...)
}
\arguments{
\item{modform, }{data as passed to \code{\link{PGLS_fossil}}.}

\item{oveRR}{an object produced by applying \code{\link{overfitRR}} to be
provided if \code{\link{PGLS_fossil}} rescaled according to \code{\link{RRphylo}} rates
should be performed.}

\item{phylo.list}{a list of phylogenetic trees to be
provided if \code{\link{PGLS_fossil}} on unscaled trees should be performed.}

\item{data}{a data.frame or list including response and predictor variables
as named in \code{modform}. If not found in \code{data}, the variables are
taken from current environment.}

\item{...}{further argument passed to \code{\link{PGLS_fossil}}.}
}
\value{
The function returns a list containing two 'RRphyloList' objects
  including results of \code{\link{PGLS_fossil}} performed by using the phylogeny as
  it is (\code{$tree}) and/or rescaled according to \code{\link{RRphylo}} rates
  (\code{$RR}).
  The output always has an attribute "Call" which returns an unevaluated call to the function.
}
\description{
Testing the robustness of \code{\link{PGLS_fossil}} results to
  sampling effects and phylogenetic uncertainty.
}
\examples{
\dontrun{
cc<- 2/parallel::detectCores()
library(phytools)
library(ape)

# generate fictional data to test the function
rtree(100)->tree
fastBM(tree)->resp
fastBM(tree,nsim=3)->resp.multi
fastBM(tree)->pred1
fastBM(tree)->pred2
data.frame(y1=resp,x2=pred1,x1=pred2)->dat

# perform RRphylo and PGLS_fossil with univariate/multivariate phenotypic data
PGLS_fossil(modform=y1~x1+x2,data=dat,tree=tree)->pgls_noRR
RRphylo(tree,resp,clus=cc)->RR
PGLS_fossil(modform=resp~pred1+pred2,RR=RR)->pgls_RR

PGLS_fossil(modform=y1~x1+x2,data=list(y1=resp.multi,x2=pred1,x1=pred2),tree=tree)->pgls2_noRR
RRphylo(tree,resp.multi,clus=cc)->RR2
PGLS_fossil(modform=resp.multi~pred1+pred2,tree=tree,RR=RR2)->pgls2_RR

# overfitPGLS routine
# generate a list of subsampled and swapped phylogenies to test
tree.list<-resampleTree(RR$tree,s = 0.25,swap.si=0.1,swap.si2=0.1,nsim=10)

# test the robustnes of PGLS_fossil with univariate/multivariate phenotypic data
ofRR<-overfitRR(RR = RR,y=resp,phylo.list=tree.list,clus=cc)
ofPGLS<-overfitPGLS(oveRR = ofRR,phylo.list=tree.list,modform = y1~x1+x2,data=dat)

ofRR2<-overfitRR(RR = RR2,y=resp.multi,phylo.list=tree.list,clus=cc)
ofPGLS2<-overfitPGLS(oveRR = ofRR2,phylo.list=tree.list,modform = y1~x1+x2,
                     data=list(y1=resp.multi,x2=pred1,x1=pred2))
}
}
\references{
Castiglione, S., Tesone, G., Piccolo, M., Melchionna, M.,
  Mondanaro, A., Serio, C., Di Febbraro, M., & Raia, P. (2018). A new method
  for testing evolutionary rate variation and shifts in phenotypic evolution.
  \emph{Methods in Ecology and Evolution}, 9:
  974-983.doi:10.1111/2041-210X.12954
}
\seealso{
\href{../doc/overfit.html}{\code{overfitPGLS} vignette} ;
  \href{../doc/Alternative-trees.html}{\code{Alternative-trees} vignette}
}
\author{
Silvia Castiglione, Carmela Serio, Giorgia Girardi, Pasquale Raia
}
