% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freedom_functions_2.R
\name{sep.hp}
\alias{sep.hp}
\title{Hypergeometric (HerdPlus) population sensitivity for imperfect test}
\usage{
sep.hp(N, n, c = 1, se, sp = 1, pstar)
}
\arguments{
\item{N}{population size (scalar or vector of same length as n)}

\item{n}{sample size (scalar or vector)}

\item{c}{The cut-point number of positives to classify a cluster
as positive, default=1, if positives < c result is negative, 
>= c is positive (scalar)}

\item{se}{test unit sensitivity (scalar)}

\item{sp}{test unit specificity, default=1 (scalar)}

\item{pstar}{design prevalence as a proportion  (scalar)}
}
\value{
a vector of population-level sensitivities
}
\description{
Calculates population sensitivity for a finite population 
  and allowing for imperfect test sensitivity and specificity, 
  using Hypergeometric distribution
}
\examples{
# examples of sep.hp
sep.hp(150, 1:5*10, 2, 0.9, 0.98, 0.1)
sep.hp(150, 30, 2, 0.9, 0.98, 15)
sep.hp(150, 30, 1, 0.9, 0.98, 15)
sep.hp(150, 30, 1, 0.9, 0.98, 0.1)
}
\keyword{methods}
