% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rajive.R
\name{get_joint_scores_robustH}
\alias{get_joint_scores_robustH}
\title{Computes the joint scores.}
\usage{
get_joint_scores_robustH(
  blocks,
  block_svd,
  initial_signal_ranks,
  sv_thresholds,
  n_wedin_samples = 1000,
  n_rand_dir_samples = 1000,
  joint_rank = NA
)
}
\arguments{
\item{blocks}{List. A list of the data matrices.}

\item{block_svd}{List. The SVD of the data blocks.}

\item{initial_signal_ranks}{Numeric vector. Initial signal ranks estimates.}

\item{sv_thresholds}{Numeric vector. The singular value thresholds from the initial signal rank estimates.}

\item{n_wedin_samples}{Integer. Number of wedin bound samples to draw for each data matrix.}

\item{n_rand_dir_samples}{Integer. Number of random direction bound samples to draw.}

\item{joint_rank}{Integer or NA. User specified joint_rank. If NA will be estimated from data.}
}
\description{
Estimate the joint rank with the wedin bound, compute the signal scores SVD, double check each joint component.
}
