library(testthat)
library(RandomGaussianNB)

test_that("random_gaussian_nb fits & predicts correctly", {
  set.seed(123)
  n <- 60; p <- 5; K <- 3
  X <- matrix(rnorm(n*p), n, p)
  y <- sample(letters[1:K], n, TRUE)
  df <- data.frame(class = y, X)

  mod <- random_gaussian_nb(df, response = "class",
                            n_iter = 20, feature_fraction = 0.5, cores = 1)

  expect_s3_class(mod, "random_gaussian_nb")
  expect_true(length(mod$.models) == 20)

  preds <- predict(mod, df[, -1], type = "class")
  expect_true(is.factor(preds))
  expect_identical(levels(preds), mod$.classes)
  expect_length(preds, n)

  probs <- predict(mod, df[, -1], type = "prob")
  expect_true(is.data.frame(probs))
  expect_equal(dim(probs), c(n, length(mod$.classes)))
  expect_equal(rowSums(probs), rep(1, nrow(probs)), tolerance = 1e-6)
})
