% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mpm_elementwise_apply.R
\name{mpm_elementwise_apply}
\alias{mpm_elementwise_apply}
\alias{mat_elementwise_apply}
\title{Apply a function element-wise to a list of matrices}
\usage{
mat_elementwise_apply(x, fun, na_handling = "stop", ...)

mpm_elementwise_apply(x, fun, na_handling = "stop", ...)
}
\arguments{
\item{x}{A list of matrices.}

\item{fun}{The function to apply to the elements.}

\item{na_handling}{A character string specifying how to handle NA values.
Possible values are "stop" (throw an error when NA values are encountered),
"zero" (convert NA values to 0), and "ignore" (NA values are ignored and
passed to `fun`). Handling can then be processed appropriately by that
function (e.g., with `na.rm`).}

\item{...}{Additional arguments passed to `fun`.}
}
\value{
A matrix containing the result of applying the function element-wise
  to the corresponding elements across the matrices.
}
\description{
This function applies a specified function element-wise to the corresponding
elements across a list of matrices.
}
\examples{
mpms <- Compadre$mat[Compadre$SpeciesAuthor == "Haplopappus_radiatus"]

#The object mpms is a list, containing compadre objects
class(mpms)
class(mpms[[1]])

# Get the mean, max and min for the matrices
mpm_elementwise_apply(mpms, mean)
mpm_elementwise_apply(mpms, max)
mpm_elementwise_apply(mpms, min)

# extract list of matA and take mean
mats <- matA(mpms)
mat_elementwise_apply(mats, mean)

# This should be the same as mat_mean()
mat_mean(mats)

# Mean values, with 25\% trimmed from each end
mat_elementwise_apply(mats, mean, trim = 0.25)

# weighted mean, where the second matrix is weighted to 100\% and the others to 0\%
# do demonstrate usage. The result should be the same as mats[[2]]
mat_elementwise_apply(mats, weighted.mean, w = c(0,1,0,0))
mats[[2]]

#min and max values
mat_elementwise_apply(mats, min)
mat_elementwise_apply(mats, max)

#Demonstrating NA handling
#First adding some NA values to the matrices
mats[[2]][3,2] <- NA

#replace the NA with a 0
mat_elementwise_apply(mats, min, na_handling = "zero")

#ignore the NA
mat_elementwise_apply(mats, min, na_handling = "ignore")

#ignore the NA, but pass na.rm = TRUE to the function (min)
mat_elementwise_apply(mats, min, na_handling = "ignore", na.rm = TRUE)
}
\seealso{
Other data management: 
\code{\link{cdb_flatten}()},
\code{\link{cdb_id_stages}()},
\code{\link{cdb_id_studies}()},
\code{\link{cdb_id}()},
\code{\link{cdb_mean_matF}()},
\code{\link{cdb_rbind}()},
\code{\link{cdb_unflatten}()},
\code{\link{cdb_unnest}()},
\code{\link{mpm_mean}()},
\code{\link{mpm_median}()},
\code{\link{mpm_sd}()},
\code{\link{string_representation}}
}
\concept{data management}
