% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/string_representation.R
\name{string_representation}
\alias{string_representation}
\alias{mat_to_string}
\alias{vec_to_string}
\alias{string_to_mat}
\alias{string_to_vec}
\title{Convert vectors or square numeric matrices to and from string representation}
\usage{
mat_to_string(mat)

vec_to_string(vec)

string_to_mat(mat_str)

string_to_vec(vec_str, numeric = FALSE)
}
\arguments{
\item{mat}{A square numeric matrix}

\item{vec}{A vector}

\item{mat_str}{A square numeric matrix in string representation}

\item{vec_str}{A vector in string representation}

\item{numeric}{Logical value indicating whether a string representation of a
vector should be coerced to numeric (if FALSE remains character)}
}
\value{
A square numeric matrix (\code{string_to_mat}), vector
(\code{string_to_vec}), or string (\code{mat_to_string} or
\code{vec_to_string}).
}
\description{
Functions to convert vectors or square numeric matrices to and from string
representation, which is primarily useful for writing data frames with
list-columns containing vectors or matrices to a flat file format such as
csv.

String representations of vectors and matrices begin with an open bracket
("[") and end with a closed bracket ("]"). Matrix elements are separated with
a space ("[0.2 0.3 0.1 0]") whereas vector elements are separate with two
vertical bars ("[Seedling||Juvenile||Reproductive]").
}
\examples{
mat_str <- "[3.3 5.2 6.1 0.1 NA 0.3 0.2 0.4 0.1]"
mat <- string_to_mat(mat_str)

vec1_str <- "[0.30||0.42||0.19||0.09]"
vec1 <- string_to_vec(vec1_str, numeric = TRUE)

vec2_str <- "[Seedling 1||Seedling 2||Juvenile||Reproductive]"
vec2 <- string_to_vec(vec2_str)

# convert back to string format
mat_to_string(mat)
vec_to_string(vec1)
vec_to_string(vec2)

\dontrun{
# non-square matrix
mat_str <- "[0.42 0.52 0.15 0.23 0.14]"
string_to_mat(mat_str)
}
}
\seealso{
\link{cdb_flatten} \link{cdb_unflatten}

Other data management: 
\code{\link{cdb_flatten}()},
\code{\link{cdb_id_stages}()},
\code{\link{cdb_id_studies}()},
\code{\link{cdb_id}()},
\code{\link{cdb_mean_matF}()},
\code{\link{cdb_rbind}()},
\code{\link{cdb_unflatten}()},
\code{\link{cdb_unnest}()},
\code{\link{mpm_elementwise_apply}()},
\code{\link{mpm_mean}()},
\code{\link{mpm_median}()},
\code{\link{mpm_sd}()}
}
\author{
Owen R. Jones <jones@biology.sdu.dk>

Patrick M. Barks <patrick.barks@gmail.com>
}
\concept{data management}
