# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Column-wise area under ROC curve (AUC)
#'
#' Calculate area under the ROC curve (AUC) for every column of a matrix or data frame. For better performance, data frame is preferred.
#'
#' @param x Matrix or data frame. Rows contain samples and columns contain features/variables.
#' @param y Factor of class labels for the data samples. A response vector with one label for each row/component of \code{x}.
#' @param args \code{NULL} (default) or list of named arguments: \describe{
#' \item{direction}{Character vector containing one of the following directions: \code{">"}, \code{"<"} or \code{"auto"} (default),
#' recycled for each feature so different directions can be used for different features.}
#' }
#'
#' @return An output is a single matrix with the same number of columns as X and "n choose 2" ( n!/((n-2)! 2!) = n(n-1)/2 ) number of rows,
#' where n is number of unique labels in y list. For example, if y contains only two unique class labels ( length(unique(lab))==2 )
#' then output matrix will have a single row containing AUC of each column.
#' If more than two unique labels are present than AUC is calculated for every possible pairing of classes ("n choose 2" of them).
#'
#' @note Change log:
#' \itemize{
#'   \item{0.1.0 Xiurui Zhu - Initiate the function.}
#' }
#'
#' @export
#' @seealso \code{caTools::colAUC} for the original \R implementation.
#' @seealso \code{\link{col_auc_vec}} for the vectorized version.
#' @example man-roxygen/ex-col_auc.R
col_auc <- function(x, y, args = NULL) {
    .Call(`_RcppColMetric_col_auc`, x, y, args)
}

#' @templateVar fun_name col_auc
#' @template template-vec_function
#'
#' @note Change log:
#' \itemize{
#'   \item{0.1.0 Xiurui Zhu - Initiate the function.}
#' }
#'
#' @export
#' @example man-roxygen/ex-col_auc_vec.R
col_auc_vec <- function(x, y, args = NULL) {
    .Call(`_RcppColMetric_col_auc_vec`, x, y, args)
}

#' Column-wise mutual information
#'
#' Calculate mutual information for every column of a matrix or data frame. Only discrete values are allowed.
#' For better performance, data frame is preferred.
#'
#' @param x Matrix or data frame of discrete values (integers). Rows contain samples and columns contain features/variables.
#' @param y Factor of class labels for the data samples. A response vector with one label for each row/component of \code{x}.
#' @param args \code{NULL} (default) or list of named arguments: \describe{
#' \item{method}{Integer indicating computation method: 0 = empirical, 1 = Miller-Madow,
#' 2 = shrink, 3 = Schurmann-Grassberger.}
#' }
#'
#' @return An output is a single matrix with the same number of columns as X and 1 row.
#'
#' @note Change log:
#' \itemize{
#'   \item{0.1.0 Xiurui Zhu - Initiate the function.}
#' }
#'
#' @export
#' @seealso \code{infotheo::mutinformation} for the original computation
#' of mutual information in \R (and also the computation methods).
#' @seealso \code{\link{col_mut_info_vec}} for the vectorized version.
#' @example man-roxygen/ex-col_mut_info.R
col_mut_info <- function(x, y, args = NULL) {
    .Call(`_RcppColMetric_col_mut_info`, x, y, args)
}

#' @templateVar fun_name col_mut_info
#' @template template-vec_function
#'
#' @note Change log:
#' \itemize{
#'   \item{0.1.0 Xiurui Zhu - Initiate the function.}
#' }
#'
#' @export
#' @example man-roxygen/ex-col_mut_info_vec.R
col_mut_info_vec <- function(x, y, args = NULL) {
    .Call(`_RcppColMetric_col_mut_info_vec`, x, y, args)
}

