% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rcss.R
\name{RcssGetCompulsoryClass}
\alias{RcssGetCompulsoryClass}
\title{Get current state of compulsory Rcssclass}
\usage{
RcssGetCompulsoryClass(Rcssclass = NULL)
}
\arguments{
\item{Rcssclass}{character vector, set of additional compulsory classes.
When NULL, function returns the current set of compulsory classes
defined in parent environments. When non-NULL, functions returns
the concatentation of the current set and new set.}
}
\description{
Fetches the value of the RcssCompulsoryClass object defined in
parent environments.
}
\examples{

# retrieve the current compulsory class
class.null <- RcssGetCompulsoryClass()

# augment the current compulsory class with more labels
class.A <- RcssGetCompulsoryClass("A")
class.A
class.B <- RcssGetCompulsoryClass("B")
class.B

# when the object RcssCompulsoryClass is set, this augments a vector
RcssCompulsoryClass <- c("X", "Y")
class.XYZ <- RcssGetCompulsoryClass("Z")
class.XYZ

}
