% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcssWrappers.R
\name{abline}
\alias{abline}
\title{Add a styled straight line to a plot}
\usage{
abline(
  a = NULL,
  b = NULL,
  h = NULL,
  v = NULL,
  reg = NULL,
  coef = NULL,
  Rcss = "default",
  Rcssclass = NULL,
  ...
)
}
\arguments{
\item{a, b}{coefficient (intercet and slope) for line}

\item{h, v}{horizontal, vertical positions for line}

\item{reg}{an object with a coef method}

\item{coef}{vector with interect and slope for line}

\item{Rcss}{style sheet object. Leave "default" to use a style
defined via RcssSetDefaultStyle().}

\item{Rcssclass}{character, style class}

\item{...}{Further parameters, see documentation of abline()}
}
\description{
This is a wrapper for R's abline function.
See R's documentation for graphics::abline for further details.
}
\examples{

# draw a set of horizontal lines and a vertical line
plot(c(0, 1), c(0, 1), type="n")
abline(h=seq(0, 1, by=0.2))
abline(v=0.8)

}
