% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polarizacion.R
\name{polarizacion_Dalton}
\alias{polarizacion_Dalton}
\title{Dimensionality of voting. Adapted version of the polarisation index from Dalton (2008) (Pd)}
\usage{
polarizacion_Dalton(datos)
}
\arguments{
\item{datos}{It is a data.frame with three columns: the first one contains the name of the political
parties. The second must have the value of the ideological location (scale from 1 to 10), and the third
one the percentage of votes obtained with respect to all the parties presented, whether or not they are
taken into account to calculate the formula.}
}
\value{
Returns the numerical value of this indicator
}
\description{
With this function the slightly adapted version of the polarisation index from Dalton (2008)
is computed to measure polarization. This index weights the ideological positions of the parties by their
election results. This indicator ranges from 0 (in the hypothetical case that all parties occupy the same
ideological position) to 10 if the parties are at the extremes of the scale position. The formula to
compute it is as follows:

\deqn{Pd=\sqrt{\sum_{i=1}^{n}p_{i}\left[\frac{\overline{x}_{i}-\overline{x}_{p}}{4.5}\right]^{2}}}
{Pd = sqrt(sum(p_j*(x_j-mean(x_p))/4.5)^2)}
for \eqn{i = 1, 2, \ldots,n}
}
\examples{
d2<- data.frame(partidos=c("RN","PDC","PS","PPD","UDI","PRSC"),
 ubicacion=c(6.36,5.31,2.73,4.13,7.04,4.00),
 c(14.12,20.76,10.05,15.42,22.36,3.54))

polarizacion_Dalton(d2)


}
