% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infect_sma.R
\docType{data}
\name{infect_sma}
\alias{infect_sma}
\title{West Nile virus pool tests for female *Culex pipiens* in the Sacramento Metropolitan Area}
\format{
A data frame with one row per tested pool (for a total of 596 pools) and 5 variables:
\describe{
  \item{lon}{Numeric. Longitude in decimal degrees (WGS84).}
  \item{lat}{Numeric. Latitude in decimal degrees (WGS84).}
  \item{est_pool_n}{Integer. Estimated number of mosquitoes in the pool (see Details).}
  \item{wnv_pos}{Logical. Whether the pool tested positive for West Nile virus (\code{TRUE}/\code{FALSE}).}
  \item{date}{Date. Pool collection date (local).}
}
}
\source{
Constructed from \code{sample_collections} in the \code{vectorsurvR} R package.
}
\usage{
data(infect_sma)
}
\description{
A dataset of PCR-tested mosquito pools used to summarize infection for female
*Culex pipiens* in the Sacramento Metropolitan Area (Sacramento, Placer, El Dorado
counties, California, USA). Each row represents a tested pool at a specific
location and date, with an estimated pool size.
}
\details{
Derived from the \pkg{vectorsurvR} sample datasets by:
\enumerate{
\item Filtering to female \emph{Culex pipiens} pools with WNV testing within the SMA
using point-in-polygon against the union of Sacramento, Placer, and El Dorado counties.
\item Estimating pool size \code{est_pool_n} for each pool by:
  \itemize{
    \item Summing total female counts from nearby collection points within the \emph{same week}
          and within a spatial radius (e.g., 2 km) to obtain \eqn{T_{\mathrm{near}}}.
    \item Counting nearby pools within the same week/radius to obtain \eqn{m_{\mathrm{near}}}.
    \item Setting \code{est_pool_n = round(max(1, T_near / m_near))}; if no nearby collections are found,
          a conservative fallback (default 25) is used.
  }
\item Coordinates are kept as WGS84 (EPSG:4326).
}

\strong{Important:} \code{est_pool_n} is an estimate for demonstration and pooled-modelling
examples; it is not the recorded laboratory pool size.
}
