% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/json.R
\name{robyn_write}
\alias{robyn_write}
\alias{print.robyn_write}
\alias{robyn_read}
\alias{print.robyn_read}
\alias{robyn_recreate}
\title{Import and Export Robyn JSON files}
\usage{
robyn_write(
  InputCollect,
  OutputCollect = NULL,
  select_model = NULL,
  dir = OutputCollect$plot_folder,
  add_data = TRUE,
  export = TRUE,
  quiet = FALSE,
  pareto_df = NULL,
  ...
)

\method{print}{robyn_write}(x, ...)

robyn_read(json_file = NULL, step = 1, quiet = FALSE, ...)

\method{print}{robyn_read}(x, ...)

robyn_recreate(json_file, quiet = FALSE, ...)
}
\arguments{
\item{InputCollect}{\code{robyn_inputs()} output.}

\item{OutputCollect}{\code{robyn_run(..., export = FALSE)} output.}

\item{select_model}{Character. Which model ID do you want to export
into the JSON file?}

\item{dir}{Character. Existing directory to export JSON file to.}

\item{add_data}{Boolean. Include raw dataset. Useful to recreate models
with a single file containing all the required information (no need of CSV).}

\item{export}{Boolean. Export outcomes into local files?}

\item{quiet}{Boolean. Keep messages off?}

\item{pareto_df}{Dataframe. Save all pareto solutions to json file.}

\item{...}{Additional parameters to export into a custom Extras element.}

\item{x}{\code{robyn_read()} or \code{robyn_write()} output.}

\item{json_file}{Character. JSON file name to read and import.}

\item{step}{Integer. 1 for import only and 2 for import and output.}
}
\value{
(invisible) List. Contains all inputs and outputs of exported model.
Class: \code{robyn_write}.
}
\description{
\code{robyn_write()} generates light JSON files with all the information
required to replicate Robyn models. Depending on user inputs, there are
3 use cases: only the inputs data, input data + modeling results data,
and input data, modeling results + specifics of a single selected model.
To replicate a model, you must provide InputCollect, OutputCollect, and,
if OutputCollect contains more than one model, the select_model.
}
\examples{
\dontrun{
InputCollectJSON <- robyn_inputs(
  dt_input = Robyn::dt_simulated_weekly,
  json_file = "~/Desktop/RobynModel-1_29_12.json"
)
print(InputCollectJSON)
}
}
