\name{getregionals}
\alias{getregionals}
\title{Extract regional events 
}
\description{
Extract regional events from a hypocenter list (catalog)
}
\usage{
getregionals(KAT, Mlat, Mlon, rad = 1000, t1 = 1, t2 = 2)
}
\arguments{
  \item{KAT}{catalog list: must include lat, lon and jsec.
}
  \item{Mlat}{central latitude
}
  \item{Mlon}{central longitude 
}
  \item{rad}{radius (km)
}
  \item{t1}{start time (julian days)
}
  \item{t2}{end  time (julian days)
}
}
\details{
Given an earthquake catalog from PDEs, for example,
extract the events that are close to a network in
a given time frame.  The limited data set may be used
to help predict arrival times for known hypocenter 
locations.

The time jsec is in julian days,
i.e. jsec=jd+hr/24+mi/(24*60)+sec/(24*3600) so that they can be compared
to t1 and t2.
}
\value{
Catalog 
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}

\seealso{RSEIS::Mine.seis, RSEIS::swig
}
\examples{


set.seed(1)
Mlat = 36.00833
Mlon = -117.8048
N = 100
degz = 5
KAT = list(lat=runif(N, Mlat-degz,Mlat+degz) ,
    lon=runif(N,Mlon-degz,Mlon+degz)  )

######  ranfdom times in January
KAT$jsec = runif(N, 1, 30) + runif(N, 0, 24)/(24) + runif(N, 0, 59)/(24*60)

######   extract regional events
localeqs = getregionals(KAT, Mlat, Mlon, rad=200 ,  t1=NULL, t2=NULL)

plot(KAT$lon, KAT$lat, pch=8, col=grey(0.75) )
points(KAT$lon[localeqs], KAT$lat[localeqs], pch=1, col='red', cex=1.5 )



}
\keyword{misc}
