% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulxR.R
\name{simulx}
\alias{simulx}
\title{Simulation of mixed effects models and longitudinal data}
\usage{
simulx(
  model = NULL,
  parameter = NULL,
  covariate = NULL,
  output = NULL,
  treatment = NULL,
  regressor = NULL,
  occasion = NULL,
  varlevel = NULL,
  group = NULL,
  project = NULL,
  nrep = 1,
  npop = NULL,
  fim = NULL,
  saveSmlxProject = NULL,
  result.file = NULL,
  addlines = NULL,
  settings = NULL
)
}
\arguments{
\item{model}{a \code{Mlxtran} model used for the simulation. It can be a text file or an outut of the inLine function.}

\item{parameter}{One of
\itemize{
\item a vector of parameters with their names and values,
\item a dataframe with parameters defined for each id or each pop
\item a string, path to a data frame (csv or txt file)
\item a string corresponding to the parameter elements automatically generated by monolix
(only when simulation is based on a Monolix project).
One of the following mlx parameter elements: "mlx_Pop", "mlx_PopUncertainSA",
"mlx_PopUncertainLin", "mlx_PopIndiv", "mlx_PopIndivCov","mlx_CondMean",
"mlx_EBEs","mlx_CondDistSample"
}}

\item{covariate}{One of
\itemize{
\item a vector of covariates with their names and values.
\item a dataframe with covariates defined for each id
\item a string, path to a data frame (csv or txt file)
\item a string corresponding to the covariate elements automatically generated by monolix
(only when simulation is based on a Monolix project).
One of the following mlx covariate elements: "mlx_Cov" and "mlx_CovDist"
}}

\item{output}{output or list of outputs. An output can be defined by
\itemize{
\item a string corresponding to the output elements automatically generated by monolix
(only when simulation is based on a Monolix project) - the format is mlx_nameofoutput.
\item a list with fields
\itemize{
\item \code{name}: a vector of output names
\item \code{time}:
\itemize{
\item a vector of times
\item a dataframe with columns id, time (columns lloq, uloq, limit are optional)
\item a string, path to a data frame (csv or txt file)
}
\item \code{lloq}: lower limit of quantification (when time is a vector of times)
\item \code{uloq}: upper limit of quantification (when time is a vector of times)
\item \code{limit}: lower bound of the censoring interval (when time is a vector of times)
}
}}

\item{treatment}{treatment or list of treatments. A treatment can be defined by
\itemize{
\item A list with fields
\itemize{
\item \code{time} : a vector of input times,
\item \code{amount} : a scalar or a vector of amounts,
\item \code{rate} : a scalar or a vector of infusion rates (default=\code{Inf}),
\item \code{tinf} : a scalar or a vector of infusion times (default=0),
\item \code{washout} : a scalar or a vector of boolean (default=F),
\item \code{adm} : (or type) the administration type (default=1),
\item \code{repeats} : the treatment cycle (optional), a vector with fields
\itemize{
\item \code{cycleDuration} : the duration of a cycle,
\item \code{NumberOfRepetitions} : the number of cycle repetition
}
\item \code{probaMissDose}: the probability to miss each dose (optional).
}
\item a dataframe with treatments defined for each id
\item a string, path to a data frame (csv or txt file)
\item a string corresponding to the treatment elements automatically generated by monolix
(only when simulation is based on a Monolix project) - for example mlx_Adm1.
}}

\item{regressor}{treatment or list of treatments. A treatment can be defined by
\itemize{
\item A list with fields
\itemize{
\item \code{name} : a vector of regressor names,
\item \code{time} : a vector of times,
\item \code{value} : a vector of values.
}
\item A dataframe with columns id, time, and regressor values
\item a string, path to a data frame (csv or txt file)
}}

\item{occasion}{An occasion can be defined by
\itemize{
\item A list with fields
\itemize{
\item \code{name} : name of the variable which defines the occasions,
\item \code{time} : a vector of times (beginnings of occasions)
}
\item A dataframe with columns id, time, occasion
\item a string, path to a data frame (csv or txt file)
\item "none", to delete an occasion structure
}}

\item{varlevel}{deprecated, use occasion instead.}

\item{group}{a list, or a list of lists, with fields:
\itemize{
\item \code{size} : size of the group (default=1),
\item \code{parameter} : if different parameters per group are defined,
\item \code{covariate} : if different covariates per group are defined,
\item \code{output} : if different outputs per group are defined,
\item \code{treatment} : if different treatments per group are defined,
\item \code{regressor} : if different regression variables per group are defined.
}
"level" field is not supported anymore in RsSimulx.}

\item{project}{the name of a Monolix project}

\item{nrep}{Samples with or without uncertainty depending which element is given as "parameter".}

\item{npop}{deprecated, Set parameter = "mlx_popUncertainSA" or "mlx_popUncertainLin" instead.}

\item{fim}{deprecated, Set parameter = "mlx_popUncertainSA" or "mlx_popUncertainLin" instead.}

\item{saveSmlxProject}{If specified, smlx project will be save in the path location
(by default smlx project is not saved)}

\item{result.file}{deprecated}

\item{addlines}{a list with fields:
\itemize{
\item \code{formula}: string, or vector of strings, to be inserted .
}
"section", "block" field are not supported anymore in RsSimulx.
You only need to specify a formula. The additional lines will be added in a new section EQUATION.}

\item{settings}{a list of optional settings
\itemize{
\item \code{seed}: initialization of the random number generator (integer) (by default a random seed will be generated)
\item \code{id.out}: add (TRUE) / remove (FALSE) columns id and group when only one element (N = 1 or group = 1) (default=FALSE)
\item \code{kw.max}: deprecated.
\item \code{replacement} : deprecated, use samplingMethod instead
\item \code{samplingMethod}: str, Sampling method used for the simulation. One of "keepOrder", "withReplacement", "withoutReplacement"
(default "keepOrder")
\item \code{out.trt}: TRUE/FALSE (default = TRUE) output of simulx includes treatment
\item \code{out.reg}: TRUE/FALSE (default = TRUE) output of simulx includes regressors
\item \code{sharedIds}: Vector of Elements that share ids. Available types are "covariate", "output",
"treatment", "regressor", "population", "individual" (default c())
\item \code{sameIndividualsAmongGroups}: boolean, if True same individuals will be simulated among all groups
(default False)
\item \code{exportData}: boolean, if True and if a path to save the smlx project (saveSmlxProject) is specified,
export the simulated dataset (smlx project directory/Simulation/simulatedData.txt)
(default False)
\item \code{regressorInterpolationMethod}: interpolation method for missing regressors. One of "lastCarriedForward" (default), "linearInterpolation"
}}
}
\value{
A list of data frames. Each data frame is an output of simulx
}
\description{
Compute predictions and sample data from \code{Mlxtran} and \code{R} models
}
\details{
simulx takes advantage of the modularity of hierarchical models for simulating
different components of a model: models for population parameters, individual
covariates, individual parameters and longitudinal data.

Furthermore, \code{simulx} allows to draw different types of longitudinal data,
including continuous, count, categorical, and time-to-event data.

The models are encoded using either the model coding language \samp{Mlxtran}.
\samp{Mlxtran} models are automatically converted into C++ codes,
compiled on the fly and linked to R using the \samp{RJSONIO} package.
That allows one to implement very easily complex models and to take advantage
of the numerical sovers used by the C++ \samp{mlxLibrary}.

See http://simulx.lixoft.com for more details.
}
\examples{
\dontrun{
myModel <- inlineModel("
[LONGITUDINAL]
input = {A, k, c, a}
EQUATION:
t0    = 0
f_0   = A
ddt_f = -k*f/(c+f)
DEFINITION:
y = {distribution=normal, prediction=f, sd=a}
[INDIVIDUAL]
input = {k_pop, omega}
DEFINITION:
k = {distribution=lognormal, prediction=k_pop, sd=omega}
")

f <- list(name='f', time=seq(0, 30, by=0.1))
y <- list(name='y', time=seq(0, 30, by=2))
parameter <- c(A=100, k_pop=6, omega=0.3, c=10, a=2)

res <- simulx(model     = myModel,
              parameter = parameter,
              occasion  = data.frame(time=c(0, 0), occ=c(1, 2)),
              output    = list(f,y),
              group     = list(size=4),
              saveSmlxProject = "./project.smlx")

res <- simulx(model     = myModel,
              parameter = parameter,
              occasion  = data.frame(time = c(0, 0, 0, 0),
                                     occ1 = c(1, 1, 2, 2),
                                     occ2 = c(1, 2, 3, 4)),
              output    = list(f,y),
              group     = list(size=4))
              
res <- simulx(model     = myModel,
              parameter = parameter,
              output    = list(f,y),
              group     = list(size=4))

plot(ggplotmlx() + geom_line(data=res$f, aes(x=time, y=f, colour=id)) +
     geom_point(data=res$y, aes(x=time, y=y, colour=id)))
print(res$parameter)

}

}
