% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_base_quality.R
\name{plot_base_quality}
\alias{plot_base_quality}
\title{Plot quality scores per position for FASTQ reads}
\usage{
plot_base_quality(
  fastq_input,
  reverse = NULL,
  quantile_lower = 0.25,
  quantile_upper = 0.75,
  plot_title = "Per-position quality scores: median and mean",
  show_median = TRUE,
  show_mean = TRUE,
  show_overlap_box = FALSE,
  tmpdir = NULL
)
}
\arguments{
\item{fastq_input}{(Required). A FASTQ file path or FASTQ object containing
(forward) reads. See \emph{Details}.}

\item{reverse}{(Optional). An optional FASTQ file path or FASTQ tibble
containing reverse reads. Defaults to \code{NULL}. See \emph{Details}.}

\item{quantile_lower}{(Optional). The lower quantile threshold for the error
bars in the plot. Defaults to \code{0.25}.}

\item{quantile_upper}{(Optional). The upper quantile threshold for the error
bars in the plot. Defaults to \code{0.75}.}

\item{plot_title}{(Optional). The title of the plot. Defaults to
\code{"Per-position quality scores: median and mean"}. Set to \code{""} for
no title.}

\item{show_median}{(Optional). If \code{TRUE} (default), a line representing
the median quality scores is added to the plot.}

\item{show_mean}{(Optional). If \code{TRUE} (default), a line representing
the mean quality scores is added to the plot.}

\item{show_overlap_box}{(Optional). If \code{TRUE}, a shaded box is drawn to
indicate the mean overlap length that would result from merging all reads in
their current state. This visualization is only applicable when
\code{reverse} is specified. Defaults to \code{FALSE}.}

\item{tmpdir}{(Optional). Path to the directory where temporary files should
be written when tables are used as input or output. Defaults to
\code{NULL}, which resolves to the session-specific temporary directory
(\code{tempdir()}).}
}
\value{
A ggplot2 object.
}
\description{
Generates a plot displaying the quality scores for each position in FASTQ
reads.
}
\details{
The mean and median quality scores for each base position over all reads are
plotted as curves. The vertical bars at each base indicate the interquartile
range.

\code{fastq_input} and \code{reverse} can either be file paths to FASTQ files
or FASTQ objects. FASTQ objects are tibbles that contain the columns
\code{Header}, \code{Sequence}, and \code{Quality}, see
\code{\link[microseq]{readFastq}}.

If \code{reverse} is provided, it is plotted together with the first plot in
its own panel. Note that the x-axis in this panel is reversed.

The vertical bars represent the interquartile range (25\% - 75\%) in the
quality scores. Custom quantile ranges can be specified via
\code{quantile_lower} and \code{quantile_upper}. Additionally, the median and
mean quality lines, and overlap-shading box may be turned off by
setting \code{show_median = FALSE}, \code{show_mean = FALSE}, or
\code{show_overlap_box = FALSE}, respectively.

If \code{fastq_input} (and \code{reverse}, if provided) contains more than
10 000 reads, the function will randomly select 10 000 rows for downstream
calculations. This subsampling is performed to reduce computation time and
improve performance on large datasets.
}
\examples{
# Define inputs
fastq_input <- system.file("extdata/small_R1.fq", package = "Rsearch")
reverse <- system.file("extdata/small_R2.fq", package = "Rsearch")

# Generate and display quality plot with both median and mean lines
qual_plots <- plot_base_quality(fastq_input = fastq_input,
                                reverse = reverse)
print(qual_plots)

# Generate and display quality plot without the plot title
qual_plots_wo_title <- plot_base_quality(fastq_input = fastq_input,
                                         reverse = reverse,
                                         plot_title = "")
print(qual_plots_wo_title)

# Generate a plot showing only the median quality line
qual_plots_median_only <- plot_base_quality(fastq_input = fastq_input,
                                            reverse = reverse,
                                            show_mean = FALSE)
print(qual_plots_median_only)

# Generate a plot showing only the mean quality line
qual_plots_mean_only <- plot_base_quality(fastq_input = fastq_input,
                                          reverse = reverse,
                                          show_median = FALSE)
print(qual_plots_mean_only)

}
