% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsearch_obj.R
\name{rsearch2phyloseq}
\alias{rsearch2phyloseq}
\title{Convert Rsearch object to phyloseq object}
\usage{
rsearch2phyloseq(rsearch.obj, sample_id_col = "sample_id")
}
\arguments{
\item{rsearch.obj}{(Required). An Rsearch object, see
\code{\link{rsearch_obj}}.}

\item{sample_id_col}{(Optional). A character string specifying the name of
the column in \code{sampledata.df} that contains sample identifiers. Defaults
to \code{"sample_id"}.}
}
\value{
A \code{\link[phyloseq]{phyloseq}} object.
}
\description{
\code{rsearch2phyloseq} converts an Rsearch object to a phyloseq
object.
}
\details{
This function converts an Rsearch object, which is a simple
\code{list}, to a \code{\link[phyloseq]{phyloseq}} object from the
\code{phyloseq} R package.
}
\examples{
\dontrun{
# Convert Rsearch object to phyloseq object
phy_obj <- rsearch2phyloseq(obj, sample_id_col = "sample_id")
}

}
\references{
\url{https://joey711.github.io/phyloseq/}
}
\seealso{
\code{\link{rsearch_obj}}
}
