% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.cv.tropsvm.R
\name{summary.cv.tropsvm}
\alias{summary.cv.tropsvm}
\title{Summarize an Analysis of Cross-Validated Tropical Support Vector Machine}
\usage{
\method{summary}{cv.tropsvm}(object, ...)
}
\arguments{
\item{object}{a fitted \code{"cv.tropsvm"} object.}

\item{\dots}{Not used. Other arguments to summary.}
}
\value{
A summary of the crucial information of a tropical support vector machine is printed, including
the selected best assignment and classification methods and the validation accuracy of each data fold. The
summary section of classification methods specifies the sectors and their intersections used to classify
points of two different categories.
}
\description{
Return a summary with a more detailed explanation of the object \code{"cv.tropsvm"}.
}
\examples{

# data generation
library(Rfast)
e <- 20
n <- 10
N <- 10
s <- 5
x <- rbind(
  rmvnorm(n, mu = c(5, -5, rep(0, e - 2)), sigma = diag(s, e)),
  rmvnorm(n, mu = c(-5, 5, rep(0, e - 2)), sigma = diag(s, e))
)
y <- as.factor(c(rep(1, n), rep(2, n)))
newx <- rbind(
  rmvnorm(N, mu = c(5, -5, rep(0, e - 2)), sigma = diag(s, e)),
  rmvnorm(N, mu = c(-5, 5, rep(0, e - 2)), sigma = diag(s, e))
)
newy <- as.factor(rep(c(1, 2), each = N))

# train the tropical svm with cross-validation
cv_tropsvm_fit <- cv.tropsvm(x, y, parallel = FALSE)

summary(cv_tropsvm_fit)
}
\seealso{
\code{predict}, \code{coef} and the \code{cv.tropsvm} function.
}
