% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tropFW.R
\name{tropFW}
\alias{tropFW}
\title{Tropical Fermat-Weber Point}
\usage{
tropFW(x)
}
\arguments{
\item{x}{a data matrix, of dimension nobs x nvars; each row is an observation vector.}
}
\value{
A list containing:
\item{fw}{The fermat-weber point.}
\item{distsum}{The sum of distance from each observation to the fermat-weber point.}
}
\description{
Compute the tropical Fermat-Weber (FW) point for a given data matrix.
The FW point minimizes the summed tropical distance to the trees described
in the data matrix.
}
\examples{
x <- matrix(rnorm(100), ncol = 10)
tropFW(x)
}
