% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/satBackup.R
\name{satBackup}
\alias{satBackup}
\title{Backup for Ruido's functions}
\usage{
satBackup(backup)
}
\arguments{
\item{backup}{path to the .RData file create by the backup of soundSat or soundMat}
}
\value{
This functions returns the same output of \code{soundSat()}, \code{soundMat()} or \code{multActivity()}
}
\description{
This function is a way to continue an unfinished process of the \code{soundSat()}, \code{soundMat()} or \code{multActivity()} functions through a backup file.
Arguments can't be inputted nor changed since the function will automatically load them from the \code{.RData} files. However you may manually change them (not recomended)
}
\examples{
\dontrun{
# It's impossible to create a functioning example since you would have to manually stop the process
# However, here is how this function is used:
## This example will load an entire day of audios to your computer, so beware.

### Downloading audiofiles from public Zenodo library
dir <- paste(tempdir(), "forExample", sep = "/")
dir.create(dir)
recName <- paste0("GAL24576_20250401_", sprintf("\%06d", seq(0, 230000, by = 10000)),".wav")
recDir <- paste(dir, recName, sep = "/")

for(rec in recName) {
  print(rec)
  url <- paste0("https://zenodo.org/records/17575795/files/", rec, "?download=1")
  download.file(url, destfile = paste(dir, rec, sep = "/"), mode = "wb")
}

sat <- soundSat(dir, backup = dir)

# Now pretend the process was interrupted (manually/your R crashed/your computer turned off)
# We get the backup file

list.files(dir)
backupDir <- paste(dir, "SATBACKUP.RData", sep = "/")

# To recall the backup you simply:

satB <- satBackup(backupDir)

head(satB$values)

unlink(dir, recursive = TRUE)
}
}
