% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute.features.R
\name{compute.features}
\alias{compute.features}
\title{Shape Features}
\usage{
compute.features(
  region,
  plg.chain,
  categories = c("geometric", "boundary", "topological")
)
}
\arguments{
\item{region}{a binary matrix that represents the region.}

\item{plg.chain}{an \eqn{n}-by-\eqn{2} numeric matrix that represents the boundary.}

\item{categories}{a character string or vector, specifying which features to compute.}
}
\value{
A numeric vector composed of the shape descriptors.
}
\description{
Compute the shape descriptors of the given region, represented by its
binary matrix and the polygonal chain of its boundary.
}
\details{
The shape descriptors are divided into three categories: geometric, boundary,
and topological. The default will compute the features from all categories.
We also note that, for the binary matrix, the ones and zeros make up the
region of interest and background, respectively.
}
\seealso{
See \href{https://en.wikipedia.org/wiki/Polygonal_chain}{Polygonal Chain}
for more information on the closed polygonal chain.
}
