% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selection.func.R
\name{conduct.phase2}
\alias{conduct.phase2}
\title{Function to identify the most promising treatment-biomarker-linked subgroup}
\usage{
conduct.phase2(formula, surv, event, data)
}
\arguments{
\item{formula}{a formula object, with the combinations of treatment and
biomarker term, e.g., formula = "T1:B1+T1:B2+T2:B1+T2:B2"}

\item{surv}{survival time}

\item{event}{the status indicator, 0=alive, 1=dead}

\item{data}{a data.frame in which to interpret the variables named in the formula}
}
\value{
conduct.phase2() select the most effective subgroup and returns the
estimated hazard ratio.
}
\description{
This function is used to estimate the effect size of each subgroup and to
select the most promising subgroup.
}
\examples{
conduct.phase2(formula = "T1:B1+T1:B2+T2:B1+T2:B2", surv = "surv",
event = "death", data = "example.1")


}
