% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extensions.R
\name{get_league_counts}
\alias{get_league_counts}
\title{League and Tier Counts}
\usage{
get_league_counts(season_id, queue_id, team_type, league_id, host_region)
}
\arguments{
\item{season_id}{A numeric argument indicating a particular ladder season. Currently, league data
is only available for season 28 and higher (i.e. data prior to this season is inaccessible).}

\item{queue_id}{\itemize{
   \item 1 = WoL 1v1
   \item 2 = WoL 2v2
   \item 3 = WoL 3v3
   \item 4 = WoL 4V4
   \item 101 = HotS 1v1
   \item 102 = HotS 2v2
   \item 103 = HotS 3v3
   \item 104 = HotS 4v4
   \item 201 = LotV 1v1
   \item 202 = LotV 2v2
   \item 203 = LotV 3v3
   \item 204 = LotV 4v4
   \item 206 = LotV Archon
}}

\item{team_type}{\itemize{
    \item 0 = Arranged
    \item 1 = Random
}}

\item{league_id}{\itemize{
   \item 0 = Bronze
   \item 1 = Silver
   \item 2 = Gold
   \item 3 = Platinum
   \item 4 = Diamond
   \item 5 = Masters
   \item 6 = Grandmaster
}}

\item{host_region}{The host region that the API call will be sent to. For \code{get_league_data}, the host
region affects the data you will receive (i.e. different regions will result in different data).
Must be one of "us", "eu", "kr", "tw", "cn". For more information on regionality, refer to
\href{https://develop.battle.net/documentation/guides/regionality-and-apis}{Regionality and APIs}.}
}
\value{
A list with tier counts and the overall league count.
}
\description{
Provides both league (i.e. bronze, silver, etc.) and tier (1, 2, 3) player counts.
}
\note{
Data is only available for season 28 and higher.
}
\examples{
\donttest{
# Get league counts for Season 35, LotV 2v2, randomly gathered teams,
# Bronze league, Korean region.
try({
    data <- get_league_counts(season_id = 35,
                              queue_id = 202,
                              team_type = 1,
                              league_id = 0,
                              host_region = "kr")
})
}
}
\references{
\itemize{
   \item \href{https://develop.battle.net/documentation/starcraft-2/community-apis}{Blizzard Community API Documentation}
   \item \href{https://develop.battle.net/documentation/guides/regionality-and-apis}{Regionality and APIs}
   }
}
