% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SHUM.R
\name{estimate_SHUM}
\alias{estimate_SHUM}
\title{Smooth Approximations Of Empirical Hyper Volume Under Manifolds}
\usage{
estimate_SHUM(beta, labels, x_mat, p = 0)
}
\arguments{
\item{beta}{The parameter we measure SHUM based on.}

\item{labels}{The labels of the Columns of the data matrix.}

\item{x_mat}{The Data Matrix}

\item{p}{p decides whether to use \eqn{s_n(x)} or \eqn{\phi_n(x)}. p = 1 stands for \eqn{\phi_n(x)} and p = 0 stands for \eqn{s_n(x)}}
}
\value{
Smooth approximation of the empirical Hyper-volume Under Manifolds Estimate
}
\description{
`SHUM` is a class of smoothed estimates of EHUM.
}
\examples{
estimate_SHUM(rep(1, 12), colnames(AL), AL)
estimate_SHUM(rep(1, 12), colnames(AL), AL, p = 1)


estimate_SHUM(1:10 , sample(c( rep("lab1", 10), rep("lab2", 10), rep("lab3", 10))),
matrix(rnorm(300), nrow = 10))

}
\references{
\itemize{

  \item Maiti, Raju and Li, Jialiang and Das, Priyam and Feng, Lei and Hausenloy, Derek and Chakraborty, Bibhas \cr
         "A distribution-free smoothed combination method of biomarkers to improve diagnostic accuracy in multi-category classification" \cr
         (available at `arXiv \url{https://arxiv.org/abs/1904.10046}).
}
}
