# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Gini's mean difference
#' 
#' Calculates Gini's mean difference of a given vector \code{x}.
#' 
#' @param x numeric vector.
#' 
#' @return A numeric value.
#' 
#' @examples
#' x <- rnorm(100)
#' GMD(x)
#' 
#' @export
GMD <- function(x) {
    .Call('_SChangeBlock_GMD', PACKAGE = 'SChangeBlock', x)
}

#' Mu
#' 
#' This function returns a vector of the block means for a given random field X.
#' 
#' @param x Numeric vector or matrix.
#' @param group strictly positive integer vector or matrix indicating the group (or block) of the corresponding observation in X.
#'        Overwrites `l` if specified.
#' @param l block length. Integer vector of length 1 or 2, depending on the number of dimensions of X, with strictly positive entries.
#' 
#' @return A numeric vector of length \code{floor(n[1] / l[1]) * floor(n[2] / l[2])}.
#' 
#' @examples 
#' X <- genField(c(50, 100), H = 100, type = 2)
#' M <- Mu(X, l = c(10, 20))
#' 
#' plot(X)
#' image(matrix(M, ncol = 5))
#' 
#' @export
Mu <- function(x, group = NULL, l = NULL) {
    .Call('_SChangeBlock_Mu', PACKAGE = 'SChangeBlock', x, group, l)
}

gamma <- function(X, h1, h2) {
    .Call('_SChangeBlock_gamma', PACKAGE = 'SChangeBlock', X, h1, h2)
}

gammaDiff <- function(X, h1, h2) {
    .Call('_SChangeBlock_gammaDiff', PACKAGE = 'SChangeBlock', X, h1, h2)
}

#' Autocovariance matrix
#' 
#' Estimates the autocovariance matrix for a given data matrix X. Via the parameter \code{direction}, it is possible to estimate only 
#' row- or columnwise autocovariance matrices, which is useful if the autocovariance function is separable.
#' 
#' @param X numeric matrix,
#' @param b numeric vector containing two integer values: the bandwidths for the row- resp. column-wise estimation.
#'        (Up to which lag should the autocovariances be estimated?) If \code{direction} > 0: only one integer must be supplied. 
#'        Bandwidths must be smaller than the dimensions of X.
#' @param M numeric vector containing two integer values, only needed for \code{type = 1}, see Details.
#' @param direction 0: all directions, 1: only row-wise autocovariances, 2: only column-wise autocovariances.
#' @param type 0: ordinary autocovariance estimation, 1: difference-based autocovariance estimation. See Details.
#' 
#' @returns A numeric matrix of size \eqn{N \times N}. If \code{direction = 0} then \eqn{N =} \code{prod(dim(X))}. 
#'          If \code{direction = 1} then \eqn{N =} \code{ncol(X)}, if \code{direction = 2} then \eqn{N =} \code{nrow(X)}.
#'          
#' @details In this function, the autocovariance matrix of \code{X} is interpreted as the autocovariance matrix of 
#'          \code{x = as.vector(X)}, i.e. where \code{X} is ordered into a vector column-wise. 
#'          If \code{type = 0}, the autocovariance to lags \eqn{h_1, h_2} is estimated using the regular estimator
#'          \deqn{\hat{\gamma}_{\text{reg}}(h_1, h_2) = 
#'           \frac{1}{(n-h_1)(m-h_2)}\sum_{i = 1}^{n-h_1} \sum_{j = 1}^{m-h_2} (Y_{i, j} - \bar{Y})(Y_{i+h_1, j+h_2} - \bar{Y}).}
#'          If \code{type = 1}, the autocovariance to lags \eqn{h_1, h_2} is estimated by a difference-based version, inspired by 
#'          the estimator of Tecuapetla-Gómez and Munk (2017) for time series:
#'          \deqn{\hat{\gamma}_{\text{diff}}(h_1, h_2) = \hat{\sigma}_{\text{diff}}^2 -
#'           \frac{1}{2(n - h_1)(m - h_2)}\sum_{i = 1}^{n-h_1} \sum_{j = 1}^{m-h_2} (Y_{i, j} - Y_{i + h_1, j + h_2})^2}
#'          with
#'          \deqn{\hat{\sigma}_{\text{diff}}^2 = \frac{1}{4} \left(\frac{1}{n(m - M_2)}\sum_{i = 1}^n \sum_{j = 1}^{m - M_2} 
#'          (Y_{i, j} - Y_{i, j+M_2})^2 + \frac{1}{(n - M_1)m}\sum_{i = 1}^{n-M_1} \sum_{j = 1}^{m} (Y_{i, j} - Y_{i+M_1, j})^2 \right),}
#'          where \eqn{M_1 =} \code{M[1]}, \eqn{M_2 = } \code{M[2]}.
#' 
#' @examples
#' X <- genField(c(20, 20))
#' autocov(X, c(4, 4))[1:10, 1:100]
#' 
#' # if separable:
#' Sigma1 <- autocov(X, 4, direction = 1)
#' Sigma2 <- autocov(X, 4, direction = 2)
#' kronecker(Sigma1, Sigma2)[1:10, 1:100]
#' 
#' @references
#' Tecuapetla‐Gómez, I., & Munk, A. (2017). Autocovariance estimation in regression with a discontinuous signal and m‐dependent errors: A difference‐based approach. Scandinavian Journal of Statistics, 44(2), 346-368.
#' 
#' @export
autocov <- function(X, b, M = as.integer( c(1, 1)), direction = 0L, type = 0L) {
    .Call('_SChangeBlock_autocov', PACKAGE = 'SChangeBlock', X, b, M, direction, type)
}

#' Dependency Matrix Theta
#' 
#' This function generates a symmetric dependency matrix \eqn{\Theta} of a 
#' specific type of spatial MA(q) model.
#' 
#' @param q model order (integer).
#' @param param MA parameter (numeric value between 0 and 1).
#' @param structure Character string, either "MA" or "AR" indicating the structure of the dependency matrix. Details below.
#' 
#' @return A matrix of size (2q + 1) x (2q + 1).
#' 
#' @details Symmetric spatial MA(q) model (or an approximation to a spatial AR(1) model) for 2-dim. random fields:
#'          \deqn{Y_{ij} = \sum_{k = -q}^q \sum_{l = -q}^q \theta_{kl} \varepsilon_{kl}.}
#'          \eqn{(\theta_{kl}) = \Theta}. \cr \cr
#'          For "MA": \deqn{\theta_{kl} = \code{param}^{|k - q - 1| + |l - q - 1|}.}
#'          For "AR": \deqn{\theta_{kl} = \tilde{\theta}_{kl} / \sqrt{\sum_{|k| \leq q} \sum_{|l| \leq q} \tilde{\theta}^2_{kl}} 
#'          \quad \text{ with } \quad \tilde{\theta}_{kl} = \code{param}^{\sqrt{k^2 + l^2}}.}
#'          
#' @examples
#' genTheta(1, 0.2, "MA")
#' 
#' genTheta(40, 0.2, "AR")
#' 
#' @export
genTheta <- function(q, param, structure = "MA") {
    .Call('_SChangeBlock_genTheta', PACKAGE = 'SChangeBlock', q, param, structure)
}

dependency <- function(E, Theta_ = NULL, q_ = NULL, param_ = NULL) {
    .Call('_SChangeBlock_dependency', PACKAGE = 'SChangeBlock', E, Theta_, q_, param_)
}

#' @param n integer value.
#' @param lower,upper lower and upper search border, between 0 and 1.
#' @param step size of the step for the search, between 0 and 1.
#' 
#' 
#' @return \code{sSizes} returns a data frame containing
#' \item{n}{the given sample size}
#' \item{s}{the exponent in question}
#' \item{ln}{the resulting block length}
#' \item{bn}{the corresponding number of block}
#' \item{ln.bn}{block length times number of blocks}
#' \item{diff}{difference between the given sample size and the number of observations covered by the blocks}
#' 
#' @examples
#' sSizes(50)
#' sSizes(50, 0.6, 0.8, 0.01)
#' 
#' @rdname sOpt
#' @export
sSizes <- function(n, lower = 0.5, upper = 1, step = 0.1) {
    .Call('_SChangeBlock_sSizes', PACKAGE = 'SChangeBlock', n, lower, upper, step)
}

#' Optimal parameter s
#' 
#' Calculates the best parameter \eqn{\tilde{s}} for a given approximation s, such that \eqn{n \; % \; \[n^{s}\] = 0}.
#' 
#' @param n Sample size(s), numeric (vector).
#' @param s Desired exponent, \eqn{0.5 \leq s \leq 1}.
#' 
#' @return \code{sOpt} returns a numeric vector of the optimal exponent(s).
#' 
#' @examples 
#' sOpt(50, 0.6)
#' sOpt(100, 0.6)
#' 
#' @export
sOpt <- function(n, s = 0.6) {
    .Call('_SChangeBlock_sOpt', PACKAGE = 'SChangeBlock', n, s)
}

