% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Method_function.R
\name{DCADMM_iter_l2}
\alias{DCADMM_iter_l2}
\title{SILFS-Based Subgroup Identification and Variable Selection Optimized by DC-ADMM under the L2 Distance}
\usage{
DCADMM_iter_l2(
  Y,
  F_hat,
  U_hat,
  r_1,
  r_2,
  r_3,
  lambda_1,
  lambda_2,
  K,
  alpha_init,
  epsilon_1,
  epsilon_2
)
}
\arguments{
\item{Y}{The response vector of length \eqn{n}.}

\item{F_hat}{The estimated factor matrix of size \eqn{n \times r}.}

\item{U_hat}{The estimated idiosyncratic factors matrix of size \eqn{n \times p}.}

\item{r_1}{The Lagrangian augmentation parameter for constraints of intercepts.}

\item{r_2}{The Lagrangian augmentation parameter for constraints of group centers.}

\item{r_3}{The Lagrangian augmentation parameter for constraints of coefficients.}

\item{lambda_1}{The tuning parameter for Center-Augmented Regularization.}

\item{lambda_2}{The tuning parameter for LASSO.}

\item{K}{The estimated group number.}

\item{alpha_init}{The initialization of intercept parameter.}

\item{epsilon_1}{The user-supplied stopping error for outer loop.}

\item{epsilon_2}{The user-supplied stopping error for inner loop.}
}
\value{
A list with the following components:
\item{alpha_curr}{The estimated intercept parameter vector of length \eqn{n}.}
\item{gamma_curr}{The estimated vector of subgroup centers of length \eqn{K}.}
\item{theta_curr}{The estimated regression coefficient vector, matched with common factor terms, with a dimension of \eqn{r}.}
\item{beta_curr}{The estimated regression coefficients matched with idiosyncratic factors, with a dimension of \eqn{p}.}
}
\description{
This function employs SILFS method and uses the corresponding Difference of Convex functions-Alternating Direction Method of Multipliers (DC-ADMM) algorithm for optimization to identify subgroup structures and conduct variable selection under the L2 Distance.
}
\examples{
n <- 50
p <- 50
r <- 3
K <- 2
alpha <- sample(c(-3,3),n,replace=TRUE,prob=c(1/2,1/2))
beta <- c(rep(1,2),rep(0,48))
B <- matrix((rnorm(p*r,1,1)),p,r)
F_1 <- matrix((rnorm(n*r,0,1)),n,r)
U <- matrix(rnorm(p*n,0,0.1),n,p)
X <- F_1\%*\%t(B)+U
Y <- alpha + X\%*\%beta + rnorm(n,0,0.5)
alpha_init <- INIT(Y,F_1,0.1)
DCADMM_iter_l2(Y,F_1,U,0.5,0.5,0.5,0.01,0.05,K,alpha_init,1,0.3)
}
\references{
He, Y., Liu, D., Wang, F., Zhang, M., Zhou, W., 2024. High-Dimensional Subgroup Identification under Latent Factor Structures.
}
\author{
Yong He, Liu Dong, Fuxin Wang, Mingjuan Zhang, Wenxin Zhou.
}
