% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ST.R
\name{ST}
\alias{ST}
\title{Testing for Sparse Signals}
\usage{
ST(X.f, Y.f, sub.size, test.set, M = 500, alpha = 0.05)
}
\arguments{
\item{X.f}{n times p design matrix.}

\item{Y.f}{Response variable.}

\item{sub.size}{The sub-sample size used for screening.}

\item{test.set}{The set of variables of interest.}

\item{M}{The number of bootstrap replications (default 500).}

\item{alpha}{The nominal level alpha (default 0.05).}
}
\value{
Values of the non-studentized and studentized statistics,
and whether the tests get rejected at the level alpha.
}
\description{
This function implements the method for testing sparse signals in
Zhang and Cheng (2017).
}
\references{
Zhang, X., and Cheng, G. (2017) Simultaneous Inference for High-dimensional
Linear Models, \emph{Journal of the American Statistical Association}, 112, 757-768.
}
\examples{
## The function is intended for large n and p.
## Use small p here for illustration purpose only.
n <- 100
p <- 10
s0 <- 3
set <- 1:s0
Sigma <- matrix(NA, p, p)
for (i in 1:p) Sigma[i,] <- 0.9^(abs(i-(1:p)))
X <- matrix(rnorm(n*p), n, p)
X <- t(t(chol(Sigma))\%*\%t(X))
beta <- rep(0,p)
beta[1:s0] <- runif(s0,0,2)
Y <- X\%*\%beta+rt(n,4)/sqrt(2)
test.set <- (s0+1):p
sub.size <- n*0.3
ST(X, Y, sub.size, test.set)
test.set <- s0:p
ST(X, Y, sub.size, test.set)
}
