% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SLCARE.R
\name{SLCARE}
\alias{SLCARE}
\title{Semiparametric Latent Class Analysis for Recurrent Event}
\usage{
SLCARE(
  formula = "x1 + x2",
  alpha = NULL,
  beta = NULL,
  data = data,
  id_col = "id",
  start_col = "start",
  stop_col = "stop",
  event_col = "event",
  K = NULL,
  gamma = 0,
  max_epochs = 500,
  conv_threshold = 0.01,
  boot = NULL
)
}
\arguments{
\item{formula}{a string specifying the variables of interest to be involved in the regression, with the format of "x1 + x2".}

\item{alpha}{initial estimate for alpha in the estimation procedure (multinomial logistic regression model). This should be NULL (default) or a numeric matrix. 'NULL' represents the initial estimate for alpha resulted from the automated initializer.}

\item{beta}{initial estimate for beta in the estimation procedure (recurrent event model). This should be NULL (default) or a numeric matrix. 'NULL' represents the initial estimate for beta resulted from the automated initializer.}

\item{data}{a long-format Dataframe, with the format similar to Simdata (a package build-in dataset).}

\item{id_col}{parameter that indicates the column name of the subject identifier in data.}

\item{start_col}{parameter that indicates the column name of the start time of the recurrent event interval in data.}

\item{stop_col}{parameter that indicates the column name of the ending time of the recurrent event interval in data.}

\item{event_col}{parameter that indicates the column name of the recurrent event indicator in data. 1 if a recurrent event is observed.}

\item{K}{pre-determined number of latent classes.}

\item{gamma}{parameter that indicates the distribution of frailty W. The default is 0 which indicates the model holds without the subject-specific frailty (i.e., W = 1), gamma = k indicates that W follows the Gamma(k, k) distribution.}

\item{max_epochs}{maximum number of iterations for the estimation algorithm.}

\item{conv_threshold}{convergence threshold for the estimation algorithm.}

\item{boot}{number of bootstrap replicates used to obtain the standard error estimation. The default is NULL which indicates bootstrap is not conducted.}
}
\description{
Fit semiparametric latent class model for recurrent event.
}
\details{
\bold{Model:}

Suppose the recurrent events process is observed with the intensity function proposed in Zhao et al. (2022):
\deqn{\lambda _{i} (t) = \sum _{k = 1} ^{K} I (\xi _{i} = k) \times \lambda _{0} (t) \times W_{i} \times \eta _{0,k} \times \exp(\tilde{Z} _{i} ^{\top} \tilde{\beta} _{0,k}) }
where \eqn{K} is the number of latent classes in the whole population,
\eqn{\xi_i} denotes the unobserved latent class membership,
\eqn{\lambda _{0} (t)} is an unspecified, continuous,
nonnegative baseline intensity function shared by all latent classes,
\eqn{C_i} is the subject specific censoring time,
\eqn{\tilde{Z}_i} is the time-independent covariates,
\eqn{W_{i}} is a positive subject-specific latent variable independent of \eqn{(\xi_i, \tilde{Z}_i, C_i)}.

The distribution of the latent class membership \eqn{\xi _{i}} is modeled by a logistic regression model:
\deqn{P(\xi _{i} = k | \tilde{Z} _{i}) = p_{k} (\alpha _{0} , \tilde{Z} _{i}) \doteq \frac{\exp(\tilde{Z} _{i} ^{\top} \alpha _{0,k})}{\sum_{k = 1}^{K}\exp(\tilde{Z} _{i} ^{\top} \alpha _{0,k}) } , \quad k = 1, \cdots, K }

\code{SLCARE} is build for introducing a robust and flexible algorithm to carry out Zhao et al. (2022)'s latent class analysis method for recurrent event data described above.
The detailed discussion of the proposed estimation algorithms can be found in the paper "SLCARE: An R package for Semiparametric Latent Class Analysis of Recurrent Events" (in preparation).

\bold{Initial Values:}

The proposed estimating algorithm needs an input of initial values for \eqn{\hat{\beta}} and \eqn{\hat{\alpha}}.
\code{SLCARE} allows users to specify the initial values for the estimation algorithm by their own choice.
\code{SLCARE} also provide an automated initializer which obtains the initial values using
a combination of K-means clustering, multinomial regression and Wang et al. (2001)'s multiplicative intensity model.
The detailed discussion of the proposed estimation algorithms can be found in the paper "SLCARE: An R package for Semiparametric Latent Class Analysis of Recurrent Events" (in preparation).

\bold{Specify the number of latent classes and individual frailty:}

\code{SLCARE} allows the frailty distribution to be W = 1 or W follows a distribution that is parameterized as Gamma(k,k). These choices of frailty distributions cover a variety of density forms.
Suggested by Zhao et al. (2022), users can choose the distribution of individual frailty and the number of latent classes based on the model entropy provided by \code{SLCARE}.
An example of model selection can be found in the paper "SLCARE: An R package for Semiparametric Latent Class Analysis of Recurrent Events" (in preparation).
}
\examples{
data(SimData)

# fit SLCARE with K = 2, formula = "x1 + x2" and default settings for other arguments
model1 <- SLCARE(formula = "x1 + x2", data = SimData, K = 2)

# summary results
summary(model1, digits = 3)

# generate model checking plot
plot(model1, type = "ModelChecking")

# plot estimated cumulative baseline intensity function
plot(model1, type = "mu0")

# generate estimated mean function plot
plot(model1, type = "EstMeans")

# check class membership probabilities of the 6th - 10th subjects in SimData
print(model1, type = "ClassProb")[6:10,]

# check the predicted number of recurrent events of the 6th - 10th subjects in SimData
print(model1, type = "PostPredict")[6:10,]

# check the change in parameter estimates in the last iteration
print(model1, type = "ConvergeLoss")
}
