% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SLIC.R
\encoding{UTF-8}
\name{SLIC}
\alias{SLIC}
\title{SLIC function based on LIC with skewed error distributions}
\usage{
SLIC(X, Y, alpha = 0.05, K = 10, nk = NULL, dist_type = "skew_normal")
}
\arguments{
\item{X}{is a design matrix}

\item{Y}{is a random response vector of observed values}

\item{alpha}{is the significance level}

\item{K}{is the number of subsets}

\item{nk}{is the sample size of subsets}

\item{dist_type}{is the type of skewed error distribution:
"skew_normal", "skew_t", or "skew_laplace"}
}
\value{
MUopt, Bopt, MAEMUopt, MSEMUopt, opt, Yopt
}
\description{
The SLIC function extends the LIC method by assuming that the error term
follows a skewed distribution (Skew-Normal, Skew-t, or Skew-Laplace),
thereby improving the length and information optimisation criterion.
}
\examples{
set.seed(123)
n <- 1000
p <- 5
X <- matrix(rnorm(n * p), ncol = p)
beta <- runif(p, 1, 2)
e <- sn::rsn(n = n, xi = 0, omega = 1, alpha = 5)
Y <- X \%*\% beta + e
SLIC(X, Y, alpha = 0.05, K = 10, dist_type = "skew_normal")

}
