#' Speed of vehicles
#'
#' Speeds of vehicles before and after adding additional signage.
#' 
#' @docType data
#' 
#' @keywords datasets
#'
#' @format A data frame with 79 rows (each vehicle) and 2 columns:
#' \describe{
#'   \item{When}{When the speed is measured; one of \code{Before} or \code{After} new signage added}
#'   \item{Speed}{The measured speed, in km/h}
#' }
#' @source 
#' Ma, Yongfeng, Wenbo Zhang, Xin Gu, and Jiguang Zhao. 2019.
#' Impacts of Experimental Advisory Exit Speed Sign on 
#' Traffic Speeds for Freeway Exit Ramp. 
#' \emph{PLoS One} \bold{14} (11):e0225203
#' 
#' @usage 
#' data(Speed)
#' 
#' @examples
#' plot(Speed ~ factor(When), data = Speed, xlab = "When recorded", ylab = "Speed (km/h)")
#' 

"Speed"
