% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_SSM.R
\name{plot.SSM}
\alias{plot.SSM}
\title{Plot smooth supersaturated model main effects}
\usage{
\method{plot}{SSM}(x, ..., grid = 200, yrange = "full", GP = TRUE)
}
\arguments{
\item{x}{An SSM object.}

\item{...}{(optional) arguments to pass to the \code{plot} function.}

\item{grid}{(optional) A number. This specifies the resolution of the plot,
\emph{i.e.} how many model evaluations are used to construct the curve.}

\item{yrange}{(optional) Character. Only "full" will have an effect.}

\item{GP}{(optional) Logical. For single variable data, the credible interval
of the metamodel error estimator will be plotted if TRUE.}
}
\description{
\code{plot.SSM} is a plot method for SSM objects. It plots the main effects
of the SSM only, that is the subset of basis terms that are dependent on a
single variable only.  For single variable data this is a plot of the
complete model.
}
\details{
For each variable, the effect is plotted over \eqn{[-1, 1]} by default
although passing an alternate range to the \code{xlim} argument will override
this.

The \code{yrange} argument is designed to automatically compute the relevant
plot range for each effect. By default a \code{ylim} value is passed to
\code{plot} that covers the range of responses. "full" results in a
\code{ylim} value that covers the range of predictions or, if appropriate,
the range of the metamodel error credible interval.

For single variable data, setting \code{GP} to TRUE will plot a credible
interval for the metamodel error estimating Gaussian process if this has been
computed for the SSM object.
}
\examples{
# A single variable example
X <- seq(-1, 1, 0.25)
Y <- sapply(X, "^", 3)
s <- fit.ssm(X, Y, GP = TRUE)
plot(s)

# A six variable example
data(attitude)
X <- transform11(attitude[ 2:7])
Y <- attitude[ , 1]
s <- fit.ssm(X, Y)
plot(s)
}

