% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_MI.R
\name{summary.ssvs_mi}
\alias{summary.ssvs_mi}
\title{Calculate Summary Statistics for SSVS-MI Results}
\usage{
\method{summary}{ssvs_mi}(object, ...)
}
\arguments{
\item{object}{An ssvs_mi result object obtained from \code{\link[=ssvs_mi]{ssvs_mi()}}}

\item{...}{Ignored}
}
\value{
A data frame with results
}
\description{
Computes summary statistics (average, minimum, and maximum) for beta coefficients, MIP and
average nonzero beta coefficients from an SSVS result object.
}
\examples{
\donttest{
data(imputed_mtcars)
outcome <- 'qsec'
predictors <- c('cyl', 'disp', 'hp', 'drat', 'wt', 'vs', 'am', 'gear', 'carb','mpg')
imputation <- '.imp'
results <- ssvs_mi(data = imputed_mtcars, y = outcome, x = predictors, imp = imputation)
summary_MI<-summary(results)
print(summary_MI)
}
}
