% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Get_nstud.R
\name{Get_nstud}
\alias{Get_nstud}
\title{Download students' number data}
\source{
<https://dati.istruzione.it/opendata/opendata/catalogo/elements1/?area=Studenti>
}
\usage{
Get_nstud(
  Year = 2023,
  filename = c("ALUCORSOETASTA", "ALUCORSOINDCLASTA"),
  verbose = TRUE,
  show_col_types = FALSE,
  autoAbort = FALSE
)
}
\arguments{
\item{Year}{Numeric or character. Reference school year  (last available is 2023).
Available in the formats: \code{2022}, \code{"2021/2022"}, \code{202122}, \code{20212022}. \code{2023} by default}

\item{filename}{Character. A string included in the name of the file to download.
By default it is \code{c("ALUCORSOETASTA", "ALUCORSOINDCLASTA")}, which are the file names used so far for the number of students by age and the number of studentsin public schools  by age and class.




Other file names are the following. The output is not currently supported by the remainder of the functions involving the number of students.


\code{"ALUITASTRACITSTA"} for the number of Italian and foreign students in public schools


\code{"ALUSECGRADOINDSTA"} for the number of students of public schools by high school address


\code{"ALUTEMPOSCUOLASTA"} for the number of students of public schools by school running time

\code{"ALUCORSOETAPAR"}, \code{"ALUCORSOINDCLAPAR"}, \code{"ALUITASTRACITPAR"}, \code{"ALUSECGRADOINDPAR"}, \code{"ALUTEMPOSCUOLAPAR"} for the data of the previous file but referring to private schools.}

\item{verbose}{Logical. If \code{TRUE}, the user keeps track of the main underlying operations. \code{TRUE} by default.}

\item{show_col_types}{Logical. If \code{TRUE}, if the \code{verbose} argument is also \code{TRUE}, the columns of the raw dataset are shown during the download. \code{FALSE} by default.}

\item{autoAbort}{Logical. Whether to automatically abort the operation and return NULL in case of missing internet connection or server response errors. \code{FALSE} by default.}
}
\value{
By default, a list of two \code{tbl_df}, \code{tbl} and \code{data.frame} objects:

\itemize{
  \item \code{$ALUCORSOETASTA}: The number of students by school, school grade and age. It provides a higher number of school than the other element
  \item \code{$ALUCORSOINDCLASTA}: The number of students and classes by school and school grade. This is a long-format dataframe.

}
}
\description{
This functions downloads the data regarding the number of students, from the open website of the Italian Ministry of Education, University and Research
}
\examples{

\donttest{
  Get_nstud(2023, filename = "ALUCORSOINDCLASTA", autoAbort = TRUE)
}



}
