% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_MUSIC.R
\name{seasonder_MUSIC_DopplerFreq2Bins}
\alias{seasonder_MUSIC_DopplerFreq2Bins}
\title{Map Doppler Frequencies to Doppler Bins}
\usage{
seasonder_MUSIC_DopplerFreq2Bins(seasonder_cs_object, doppler_values)
}
\arguments{
\item{seasonder_cs_object}{A SeaSondeRCS object representing the cross-spectral data structure.
It contains metadata and configuration for Doppler frequency and bin mapping.}

\item{doppler_values}{A numeric vector of Doppler frequency values to be mapped to Doppler bins.}
}
\value{
A numeric vector of Doppler bins corresponding to the input Doppler frequency values.
}
\description{
This function maps specified Doppler frequency values to the corresponding Doppler bins
for a given SeaSonde cross-spectral object.
}
\details{
The function performs the following steps:
\itemize{
\item Retrieves the unnormalized Doppler bin frequencies using \code{\link{seasonder_getSeaSondeRCS_MUSIC_DopplerBinsFrequency}}.
\item Retrieves the Doppler spectrum resolution using \code{\link{seasonder_getSeaSondeRCS_MUSIC_DopplerSpectrumResolution}}.
\item Retrieves the total number of Doppler cells using \code{\link{seasonder_getSeaSondeRCS_MUSIC_nDopplerCells}}.
\item Computes the Doppler bin indices corresponding to the input Doppler frequency values using
\code{\link{seasonder_computeDopplerFreq2Bins}}.
}

This mapping is essential for translating frequency-domain values into bin indices used
in further data processing or visualization.
}
\seealso{
\code{\link{seasonder_getSeaSondeRCS_MUSIC_DopplerBinsFrequency}},
\code{\link{seasonder_getSeaSondeRCS_MUSIC_DopplerSpectrumResolution}},
\code{\link{seasonder_getSeaSondeRCS_MUSIC_nDopplerCells}},
\code{\link{seasonder_computeDopplerFreq2Bins}}
}
