% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upscaling.R
\name{upscale_regular_lon_lat}
\alias{upscale_regular_lon_lat}
\title{Function for matching data between different grids}
\usage{
upscale_regular_lon_lat(
  dt,
  coarse_grid,
  uscols,
  bycols = setdiff(dimvars(dt), c("lon", "lat")),
  save_weights = NULL,
  req_frac_of_coverage = 0
)
}
\arguments{
\item{dt}{data table containing the data you want to upscale.}

\item{coarse_grid}{data table containing lons/lats of the grid you want to upscale to.}

\item{uscols}{column name(s) of the data you want to upscale (can take multiple columns at once, but assumes that the different columns have missing values at the same position).}

\item{bycols}{optional column names for grouping if you have repeated data on the same grid, e.g. use bycols = 'date' if your data table contains observations for many dates on the same grid (and the column specifying the date is in fact called 'date').}

\item{save_weights}{optional file name for saving the weights for upscaling. Used for the CHIRPS data.}

\item{req_frac_of_coverage}{Numeric value between 0 and 1. All coarse grid cells with less coverage than this value get assigned a missing value. In particular, setting this to 0 (the default) means a value is assigned to each coarse grid cell
that overlaps with at least one fine grid cell. Setting this to 1 means only coarse grid cells are kept for which we have full coverage.}
}
\value{
A data table with the upscaled values.
}
\description{
Upscales data from one regular lon-lat grid to another lon-lat grid that is coarser or of the same resolution.
It uses conservative interpolation (rather than bilinear interpolation) which is the better choice for upscaling, see details below.
If the fine grid and coarse grid are of the same resolution but shifted, results are (almost) identical to bilinear interpolation
(almost because bilinear interpolation does not account for the fact that grid cells get smaller towards the pole, which this function does).

The function addresses the following major challenges:
\itemize{
\item The fine grid does not need to be nested in the coarse grid, creating different partial overlap scenarios.
Therefore, the value of each fine grid cell may contribute to multiple (up to four) coarse grid cells.
\item Grid cell area varies with latitude, grid cells at the equator are much larger than at the poles.
This affects the contribution of grid cells (grid cells closer to the pole contribute less to the coarse grid cell average).
\item Frequently, it is required to upscale \emph{repeated} data between the same grids, for example when you want to upscale observations for many different years.
In this case, the calculation of grid cell overlaps is only done once, and not repeated every time.
\item For coarse grid cells that are only partially covered, a minimal required fraction of coverage can be specified.
\item It is memory efficient: Naive merging of data tables or distance-based matching of grid cells is avoided, since it results in
unnecessary large lookup tables that may not fit into memory when both your fine and your coarse grid are high-resolution.
}
}
\details{
Bilinear interpolation is generally not appropriate for mapping data from finer to coarser grids.
The reason is that in BI, the value of a coarse grid cell only depends on the four fine grid cells surrounding its center coordinate,
even though many fine grid cells may overlap the coarse grid cell).
Conservative interpolation calculates the coarse grid cell value by averaging all fine grid cells overlapping with it, weighted by
the fraction of overlap. This is the appropriate way of upscaling when predictions and observations constitute grid point averages, which is usually the case (Göber et al. 2008).

The grids are assumed to be \emph{regular}, but are not required to be \emph{complete} (see \code{\link{set_spatial_grid}}).
The function is faster when missing-data grid points are not contained in \code{dt} (then fewer grid points need to be matched).
}
\references{
Göber, M., Ervin Z., and Richardson, D.S. (2008): \emph{"Could a perfect model ever satisfy a naïve forecaster? On grid box mean versus point verification."} Meteorological Applications: A journal of forecasting, practical applications, training techniques and modelling 15, no. 3 (2008): 359-365.
}
