% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overoptimism.r
\name{sr_conditional_test}
\alias{sr_conditional_test}
\title{conditional test for maximum Sharpe ratios.}
\usage{
sr_conditional_test(
  srs,
  df,
  ope = 1,
  R = NULL,
  Rmax = NULL,
  zeta_0 = 0,
  conf.level = 0.95,
  alternative = c("two.sided", "less", "greater")
)
}
\arguments{
\item{srs}{A vector of Sharpe ratios, quoted in terms of a given epoch.}

\item{df}{The number of \sQuote{degrees of freedom} of the Sharpe ratios,
which are assumed to have been measured over the same period.
The degrees of freedom are one less than the number of observed returns.}

\item{ope}{the number of observations per 'epoch'. For convenience of
interpretation, The Sharpe ratio is typically quoted in 'annualized' 
units for some epoch, that is, 'per square root epoch', though returns 
are observed at a frequency of \code{ope} per epoch. 
The default value is 1, meaning the code will not attempt to guess
what the observation frequency is, and no annualization adjustments
will be made.}

\item{R}{The correlation matrix of returns. Not needed if Rmax is given.}

\item{Rmax}{The column of the correlation matrix corresponding to the 
maximal element of \code{srs}.}

\item{zeta_0}{The cutoff for the test. We test whether all Signal-noise
ratios are equal to zeta_0.  This value is quoted in terms of the same epoch
as \code{srs}.}

\item{conf.level}{confidence level of the test.}

\item{alternative}{a character string specifying the alternative hypothesis,
must be one of \code{"two.sided"} (default), \code{"greater"} or
\code{"less"}. You can specify just the initial letter.}
}
\value{
A list with class \code{"htest"} containing the following components:
\item{statistic}{the value of the conditional normal statistic.}
\item{parameter}{the degrees of freedom for the statistic.}
\item{p.value}{the p-value for the test.}
\item{conf.int}{a one-sided confidence interval appropriate to the specified alternative hypothesis.}
\item{alternative}{a character string describing the alternative hypothesis.}
\item{method}{a character string indicating what type of test was performed.}
\item{data.name}{a character string giving the name(s) of the data.}
}
\description{
Performs tests for the hypothesis 
\deqn{\zeta_{(k)} \le \zeta_0}{zeta_(k) <= zeta_0}
against the alternative
\deqn{\zeta_{(k)} > \zeta_0,}{zeta_(k) > zeta_0,}
where \eqn{\zeta_{(k)}}{zeta_(k)} is the signal-noise ratio of the
asset selected because it has the largest Sharpe ratio.
The test is conditional on having selected the maximum.
Testing is via the polyhedral lemma of Lee \emph{et al.}
}
\details{
Performs the conditional estimation procedure as outlined in 
Section 4.1.5 of \emph{The Sharpe Ratio: Statistics and Applications}.
}
\examples{
# generate some fake data
ope <- 252
zeta0 <- 1.0
set.seed(1234)
zetas <- rsr(50, zeta=zeta0, df=ope*2, ope=ope)
sr_conditional_test(zetas,df=ope*2,ope=ope,R=diag(length(zetas)))
}
\references{
Pav, S. E. "The Sharpe Ratio: Statistics and Applications." CRC Press, 2021.

Pav, S. E. "Conditional inference on the asset with maximum Sharpe ratio."
2019 \url{https://arxiv.org/abs/1906.00573}

Lee, J. D., Sun, D. L., Sun, Y. and Taylor, J. E. "Exact post-selection inference, 
with application to the Lasso." Ann. Statist. 44, no. 3 (2016): 907-927.
doi:10.1214/15-AOS1371. \url{https://arxiv.org/abs/1311.6238}
}
\seealso{
\code{\link{reannualize}}

sr_max_test
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
\keyword{htest}
\keyword{overoptimism}
