% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/view_curated_oagenes.R
\name{view_curated_oagenes}
\alias{view_curated_oagenes}
\title{View curated osteoarthritis associated genes}
\usage{
view_curated_oagenes(skeletalvis)
}
\arguments{
\item{skeletalvis}{The path to the SkeletalVis folder.}
}
\value{
A data frame with the following columns:
\describe{
  \item{PMID}{The PubMed ID of the paper describing the observation.}
  \item{Gene}{The human gene symbol of the gene modulated in the study.}
  \item{Effect on gene product}{The effect of the gene modulation on the gene product.}
  \item{Model}{The type of OA model where the gene has been modulated.}
  \item{Susceptibility observed}{Increase (detrimental) or decrease (protective) in OA severity upon gene modulation.}
  \item{Inferred gene effect}{Based on the modulation effect, whether the gene is protective or detrimental in OA.}
  \item{Delivery}{The tissue specificity of the gene modulation.}
  \item{Species}{The species under study.}
  \item{pub_date}{The date of publication (epub).}
  \item{LastAuthor}{The last author of the publication.}
  \item{Type}{Genetic or exogenous modulation.}
  \item{Intervention}{For exogenous modulations, the method of gene modulation.}
  \item{simpleModel}{The broad type of OA model where the gene has been modulated.}
  \item{effectConsensus}{Consensus inferred gene effect across observations; 'ambiguous' if discrepancies exist.}
  \item{NumStudies}{The number of publications studying each gene.}
}
}
\description{
Retrieves the OATargets table of literature curated genes associated with osteoarthritis joint damage in animals.
}
\examples{
skeletalvis <- load_skeletalvis(demo=TRUE)
oatargets <- view_curated_oagenes(skeletalvis)

}
