% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.shr.R
\name{print.shr}
\alias{print.shr}
\title{Print method for \code{shrSplines} objects}
\usage{
\method{print}{shr}(x, conf.int = 0.95, digits = 4, pvalDigits = 4, eps = 0.0001, ...)
}
\arguments{
\item{x}{a \code{shr} object, i.e., the result of a call to the
\link{shr} function with \code{hazard}="Splines".}

\item{conf.int}{The level of confidence for the hazard ratios. The default is \code{0.95}.}

\item{digits}{number of digits to print.}

\item{pvalDigits}{number of digits to print for p-values.}

\item{eps}{convergence criterion used for p-values.}

\item{\dots}{other unusued arguments.}
}
\value{
No return value.
}
\description{
Print a summary of a fitted illness-death model using the penalized
likelihood approach.
}
\examples{

\donttest{
# a penalized survival model 
library(prodlim)
data(testdata)
fit.su <- shr(Hist(time=list(l,r),id)~cov,data=testdata,method="Splines") 
print(fit.su) 
}
}
\seealso{
\link{summary.shr}, \link{plot.shr}
}
\author{
R: Celia Touraine <Celia.Touraine@isped.u-bordeaux2.fr> Fortran:
Pierre Joly <Pierre.Joly@isped.u-bordeaux2.fr>
}
\keyword{methods}
