% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloadData.R
\name{checksums}
\alias{checksums}
\title{Calculate checksum for a module's data files}
\usage{
checksums(module, path, ...)
}
\arguments{
\item{module}{Character string giving the name of the module.}

\item{path}{Character string giving the path to the module directory.}

\item{...}{Passed to \code{\link[reproducible:Checksums]{reproducible::Checksums()}}, notably, \code{write},
\code{quickCheck},  \code{checksumFile} and \code{files}.}
}
\description{
Verify (and optionally write) checksums for data files in a module's
\file{data/} subdirectory. The file \file{data/CHECKSUMS.txt} contains the
expected checksums for each data file.
Checksums are computed using \code{reproducible:::.digest}, which is simply a
wrapper around \code{digest::digest}.
}
\details{
Modules may require data that for various reasons cannot be distributed with
the module source code. In these cases, the module developer should ensure
that the module downloads and extracts the data required. It is useful to not
only check that the data files exist locally but that their checksums match
those expected.
}
\note{
In version 1.2.0 and earlier, two checksums per file were required
because of differences in the checksum hash values on Windows and Unix-like
platforms. Recent versions use a different (faster) algorithm and only require
one checksum value per file.
To update your \file{CHECKSUMS.txt} files using the new algorithm:
\enumerate{
\item specify your module (\code{moduleName <- "my_module"});
\item use a temporary location to ensure all modules get fresh copies of the data
(\code{tmpdir <- file.path(tempdir(), "SpaDES_modules")});
\item download your module's data to the temp dir (\code{downloadData(moduleName, tmpdir)});
\item initialize a dummy simulation to ensure any 'data prep' steps in the
\code{.inputObjects} section are run (\code{simInit(modules = moduleName)});
\item recalculate your checksums and overwrite the file
(\code{checksums(moduleName, tmpdir, write = TRUE)});
\item copy the new checksums file to your working module directory
(the one not in the temp dir)
(\code{file.copy(from = file.path(tmpdir, moduleName, 'data', 'CHECKSUMS.txt'), to = file.path('path/to/my/moduleDir', moduleName, 'data', 'CHECKSUMS.txt'), overwrite = TRUE)}).
}
}
