% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spader.R
\name{SimilarityPair}
\alias{SimilarityPair}
\title{Estimation of two-assemblage similarity measures}
\usage{
SimilarityPair(X, datatype = c("abundance", "incidence_freq",
  "incidence_raw"), units, nboot = 200)
}
\arguments{
\item{X}{a matrix/data.frame of species abundances/incidences.\cr}

\item{datatype}{type of input data, "abundance", "incidence_freq" or "incidence_raw". \cr}

\item{units}{number of sampling units in each community. For \code{datatype = "incidence_raw"}, users must specify the number of sampling units taken from each community. This argument is not needed for "abundance" and "incidence_freq" data. \cr}

\item{nboot}{an integer specifying the number of replications.}
}
\value{
a list of ten objects: \cr\cr
\code{$datatype} for showing the specified data types (abundance or incidence). \cr\cr
\code{$info} for summarizing data information. \cr\cr
\code{$Empirical_richness} for showing the observed values of the richness-based similarity indices
include the classic two-community Jaccard and Sorensen indices. \cr\cr
\code{$Empirical_relative} for showing the observed values of the equal-weighted similarity indices
for comparing species relative abundances including Horn, Morisita-Horn, regional overlap,
Chao-Jaccard and Chao-Sorensen abundance (or incidence) measures based on species relative abundances. \cr \cr
\code{$Empirical_WtRelative} for showing the observed value of the Horn similarity index for comparing
size-weighted species relative abundances based on Shannon entropy under equal-effort sampling. \cr\cr
\code{$Empirical_absolute} for showing the observed values of the similarity indices for comparing
absolute abundances. These measures include the Shannon-entropy-based measure, 
Morisita-Horn and the regional overlap measures based on species absolute abundances, as well as the Bray-Curtis index.
All measures are valid only under equal-effort sampling. \cr\cr
The corresponding four objects for showing the estimated similarity indices are:
\code{$estimated_richness}, \code{$estimated_relative}, \code{$estimated_WtRelative} and \code{$estimated_Absolute}. \cr\cr
}
\description{
\code{SimilarityPair}: Estimation various similarity indices for two assemblages. The richness-based
indices include the classic two-community Jaccard and Sorensen indices; the abundance-based
indices include the Horn, Morisita-Horn, regional species-overlap, two-community Bray-Curtis and the
abundance-based Jaccard and Sorensen indices. Three types of data are supported: Type (1)
abundance data (datatype="abundance"), Type (2) incidence-frequency data
(datatype="incidence_freq"), and Type (2B) incidence-raw data (datatype="incidence_raw"); see
\code{SpadeR-package} details for data input formats.
}
\examples{
\dontrun{
data(SimilarityPairData)
# Type (1) abundance data 
SimilarityPair(SimilarityPairData$Abu,"abundance",nboot=200)
# Type (2) incidence-frequency data 
SimilarityPair(SimilarityPairData$Inci,"incidence_freq",nboot=200)
# Type (2B) incidence-raw data 
SimilarityPair(SimilarityPairData$Inci_raw,"incidence_raw",units=c(19,17),nboot=200)
}
}
\references{
Chao, A., Chazdon, R. L., Colwell, R. K. and Shen, T.-J. (2005). A new statistical approach for assessing similarity of species composition with incidence and abundance data. Ecology Letters, 8, 148-159.\cr\cr
Chao, A., and Chiu, C. H. (2016). Bridging the variance and diversity decomposition approaches to beta diversity via similarity and differentiation measures. Methods in Ecology and Evolution, 7, 919-928. \cr\cr
Chao, A., Jost, L., Hsieh, T. C., Ma, K. H., Sherwin, W. B. and Rollins, L. A. (2015). Expected
Shannon entropy and Shannon differentiation between subpopulations for neutral genes under the finite island model. Plos One, 10:e0125471. \cr\cr
Chiu, C. H., Jost, L. and Chao, A. (2014). Phylogenetic beta diversity, similarity, and differentiation measures based on Hill numbers. Ecological Monographs, 84, 21-44.\cr\cr
}

