% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srdrn.R
\name{predict.srdrn}
\alias{predict.srdrn}
\title{Predict method for SRDRN}
\usage{
\method{predict}{srdrn}(object, newdata, time_points = NULL, ...)
}
\arguments{
\item{object}{A trained SRDRN object.}

\item{newdata}{A 3D array of shape (N_1, N_1, n) representing the new coarse resolution data to be downscaled,
where N_1 x N_1 is the coarse resolution of the training samples and n is the number of samples to be downscaled.
The two first dimensions are the spatial coordinates in grid,
and the third dimension refers to the samples (e.g. time).}

\item{time_points}{An optional numeric vector of time points of the new data.}

\item{...}{Additional parameters (not used).}
}
\value{
A 3D array of shape (N_2, N_2, n) representing the predicted data,
where N_2 x N_2 is the fine resolution of the training samples.
}
\description{
This function makes predictions using a trained SRDRN model.
It takes a trained SRDRN object and new data as input,
normalizes the new data, and uses the model to make predictions.
The predictions are then rescaled back to the original range.
}
\details{
The predict method for the SRDRN class takes a trained SRDRN object and new data as input.
The input resolution (N_1 x N_1) has to match the input dimension of the training samples.
The method normalizes the new data using the same min-max scaling used during training.
The new data is reshaped to match the input shape of the model,
and the model is used to make predictions.
The output data has the same fine resolution (N_2 x N_2) as the target training data.
The predictions are rescaled back to the original range using the min-max scaling parameters
of the training data.
The output is a 3D array of the predicted data.
}
\examples{
\donttest{
 # Generate dummy low-resolution (16×16) and high-resolution (32×32) data
 n <- 10
 input  <- array(runif(8 * 8 * n),  dim = c(8, 8, n))
 target <- array(runif(16 * 16 * n),  dim = c(16, 16, n))
 
 time_vec <- 1:n
 model <- srdrn(
   coarse_data  = input,
   fine_data = target,
   time_points = time_vec,
   cyclical_period = 365,
   temporal_layers = c(32, 64),
   epochs = 1,
   batch_size = 4
 )
 
 n_new <- 3
 newdata <- array(runif(8 * 8 * n_new),
                      dim = c(8, 8, n_new))
 predictions <- predict(model, newdata, 1:n_new)
}

}
\seealso{
\code{\link{srdrn}} for fitting SRDRN model.
}
