% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EnsRps.R
\name{EnsRps}
\alias{EnsRps}
\alias{FairRps}
\title{Calculate the ensemble-adjusted Ranked Probability Score (RPS) for categorical forecasts}
\usage{
EnsRps(ens, obs, R.new = NA, format = c("category", "members"))

FairRps(ens, obs, format = c("category", "members"))
}
\arguments{
\item{ens}{matrix with N rows representing N time instances of categorical ensemble forecasts as follows: If `format = category` (the default), then ens[t,r] indicates the category that the r-th ensemble member predicts for time t. Note that categories must be positive integers. If `format = members`, then ens[t,k] is the number of ensemble members that predict category k at time t.}

\item{obs}{vector of length N, or matrix with N rows, representing the N observed category as follows: If `format = category', obs is a vector and obs[t] is the category observed at time t. If `format = members`, obs is a matrix where obs[t,k] = 1 (and zero otherwise) if category k was observed at time t}

\item{R.new}{ensemble size for which the scores should be adjusted, defaults to NA (no adjustment)}

\item{format}{string, 'category' (default) or 'members' (can be abbreviated). See descriptions of arguments `ens` and `obs` for details.}
}
\value{
numeric vector of length N with the ensemble-adjusted RPS values
}
\description{
Calculate the ensemble-adjusted Ranked Probability Score (RPS) for categorical forecasts
}
\details{
`FairRps(ens, obs)` returns `EnsRps(ens, obs, R.new=Inf)`
}
\examples{
data(eurotempforecast)
EnsRps(ens.cat, obs.cat, R.new=Inf)
}
\seealso{
EnsBrier, EnsQs, EnsCrps
}
