% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{weekly_return}
\alias{weekly_return}
\title{Compute Weekly Returns of a Vector.}
\usage{
weekly_return(vec)
}
\arguments{
\item{vec}{a numeric vector of asset returns.}
}
\value{
A numeric vector of weekly returns.
}
\description{
This function takes a numeric vector of asset returns and computes weekly returns.
}
\note{
The input data must be an xts object with dates as rownames.
}
\examples{

# Compute weekly returns of an asset vector
require(xts)
asset_returns_xts <- xts(c(29.2, 30.0, 36.2, 30.4, 38.5, -35.6, 34.5),
                         order.by = as.Date(c("2022-05-01", "2022-05-08", "2022-05-15",
                                             "2022-05-22", "2022-05-29", "2022-06-05",
                                             "2022-06-12")))
weekly_return(asset_returns_xts)


}
\seealso{
\code{\link{monthly_return}}, \code{\link{annual_return}}
}
