% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defStormsList.R
\docType{methods}
\name{getScale}
\alias{getScale}
\alias{getScale,storm-method}
\alias{getScale,stormsList-method}
\title{Getting maximum level in the wind scale}
\usage{
getScale(s)

\S4method{getScale}{storm}(s)

\S4method{getScale}{stormsList}(s)
}
\arguments{
\item{s}{\code{storm} or \code{stormsList} object.}
}
\value{
numeric vector.
}
\description{
The \code{getScale()} function return the maximum wind scale category reached by
each storm in the \code{storm} or \code{stormsList} object.
}
\examples{
\donttest{
#Creating a stormsDataset
sds <- defStormsDataset()

#Getting storm track data for all storms near New Caledonia
sts <- defStormsList(sds=sds, loi = "New Caledonia")

#Getting maximum level in the wind scale
#reached by each storm in the sts object
getScale(sts)
}
}
