% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeRast.R
\name{writeRast}
\alias{writeRast}
\title{Exporting rasters to GeoTIFF or NetCDF files}
\usage{
writeRast(rast, filename = NULL, path = "./", ...)
}
\arguments{
\item{rast}{\code{SpatRaster} object.}

\item{filename}{character. Output file name. Can be either a \code{".tiff"} file (GeoTIFF) or \code{".nc"} (NetCDF).
By default \code{filename=NULL} and the name of the file is generated based on
raster information (storms and products) with the '.tiff' extension.}

\item{path}{character. Path to the directory where the file is exported to. By default \verb{path=./'}.}

\item{...}{Additional arguments to be passed to
\href{https://rdrr.io/cran/terra/man/writeRaster.html}{\code{terra::writeRaster}}
function when saving to \code{".tiff"} format.}
}
\value{
\code{NULL}
}
\description{
The \code{writeRast()} function exports rasters stored in SpatRaster objects to
GeoTIFF or NetCDF files.
}
\examples{
# Creating a stormsDataset
\donttest{
sds <- defStormsDataset()

# Getting storm track data for tropical cyclone Pam (2015) near Vanuatu
pam <- defStormsList(sds = sds, loi = "Vanuatu", names = "PAM")

# Computing maximum sustained wind speed
pam.msw <- spatialBehaviour(pam)

# Exporting maximum sustained wind speed raster layer to a GeoTIFF file
writeRast(pam.msw, path = paste0(tempdir(), "/"))

# Computing power dissipation index for several storms near New Caledonia
sts.nc <- defStormsList(sds = sds, loi = "New Caledonia")
pdi.nc <- spatialBehaviour(sts.nc, product = "PDI")

# Exporting the power dissipation index raster layers to a NetCDF file
writeRast(pdi.nc, path = paste0(tempdir(), "/"))
}
}
