% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_methods-PLOT.R
\docType{methods}
\name{plotPerformance}
\alias{plotPerformance}
\alias{plotPerformance,Strategy-method}
\title{Plot Strategy Performance}
\usage{
plotPerformance(object, which = NULL, of = "portfolio", from = NULL,
  until = NULL, use.backtest = FALSE, include.costs = TRUE,
  plot.params = TRUE, plot.params.names = NULL, plot.params.first = TRUE,
  ...)

\S4method{plotPerformance}{Strategy}(object, which = NULL,
  of = c("portfolio", "assets"), from = NULL, until = NULL,
  use.backtest = FALSE, include.costs = TRUE, plot.params = TRUE,
  plot.params.names = NULL, plot.params.first = TRUE, ...)
}
\arguments{
\item{object}{An object of class \code{Strategy}.}

\item{which}{Names or number of assets that should be included in performance. If a portfolio performance from only a subset of the assets is calculated, the weights are scaled accordingly.}

\item{of}{Performance to be extracted from assets separately or the portfolio performance.}

\item{from}{The date in character format \code{"yyyy-MM-dd"} or as date-object from which performance shall be plotted. If \code{NULL}, the start date of the performances is used.}

\item{until}{The date in character format \code{"yyyy-MM-dd"} or as date-object until which performance shall be plotted. If \code{NULL}, the end date of the performances is used.}

\item{use.backtest}{If \code{TRUE}, the signals from the backtesting output are considered for performance calculation. If \code{FALSE}, the signals from the normal strategy execution with the intial parameters are used.}

\item{include.costs}{If \code{FALSE}, the fixed and relative trading costs are NOT considered for performance calculation. Default value is \code{TRUE}. As default values for costs are \code{0}, this argument is redundant if no costs are given.}

\item{plot.params}{If set to TRUE, the parameters used for the performance periods are plotted into the chart. Requires that use.backtest is set to \code{TRUE}.}

\item{plot.params.names}{New parameter names to be shown can be supplied. Requires that use.backtest is set to \code{TRUE} to take effect.}

\item{plot.params.first}{If \code{TRUE}, the parameter for the first period is plotted. Otherwise, the parameters are plot at the point on the x-axis, from which they are valid. Requires that use.backtest is set to \code{TRUE} to take effect.}

\item{...}{Further arguments that can be passed to the underlying plot()-function.}
}
\description{
Plots performance of an object of class \code{Strategy}.
}
\examples{
##Not run:

# MA(200)-Strategy
params <- list(k=200)
myStrat.MA <- Strategy(assets=assets, strat="MA", strat.params=params)

# Plot MA(200)-Strategy
plotPerformance(myStrat.MA, from="2015-01-01", until="2015-12-31")

# Plot backtested MA(200)-Strategy
# plotPerformance(myStrat.MA, from="2015-01-01", until="2015-12-31", use.backtest=TRUE)

##End(Not run)
}
