% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supmz.R
\name{supmz}
\alias{supmz}
\alias{supmz.default}
\title{Detecting Structural Change with Heteroskedasticity}
\usage{
supmz(formula, data, nBoot = 100)

\method{supmz}{default}(formula, data, nBoot = 100)
}
\arguments{
\item{formula}{Formula for the linear model to be used. It may contain any number of independent variables.}

\item{data}{Data frame containing dependent and independent variables.}

\item{nBoot}{Number of bootstrap samples to compute the critical region.}
}
\value{
MZ Gives values of MZ as given by Mumtaz et.al (2017)

BreakLocation Provides the data point position where the structural break occured

SupMzValue Returns the supremum value from MZ values

SupMZ0 Returns the bootstrapped critical value for testing the significance of SupMZ

nBoot Shows the number of bootstrap samples used to compute the critical region
}
\description{
Calculates the sup MZ value to detect the unknown structural break points under Heteroskedasticity
}
\examples{

data(Japan)
fm1 <- supmz(formula = C~Y, data = Japan, nBoot = 10)
fm1

data(Belgium)
fm2 <- supmz(formula = C~Y, data = Belgium, nBoot = 10)
fm2

data(Srilanka)
fm3 <- supmz(formula = C~Y, data = Srilanka, nBoot = 10)
fm3

}
\references{
Mumtaz Ahmed, Gulfam Haider & Asad Zaman (2017).
Detecting structural change with heteroskedasticity.
\emph{Communications in Statistics - Theory and Methods}.
\strong{46}(21):10446-10455,
DOI: 10.1080/03610926.2016.1235200
}
\author{
\enumerate{
         \item Muhammad Yaseen (\email{myaseen208@gmail.com})
         \item Sami Ullah      (\email{samiullahuos@gmail.com})
         \item Gulfam Haider   (\email{haider.gulfam786@gmail.com})
         }
}
