% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_model_OrdOrd_copula.R
\name{fit_copula_submodel_OrdOrd}
\alias{fit_copula_submodel_OrdOrd}
\title{Fit ordinal-continuous copula submodel}
\usage{
fit_copula_submodel_OrdOrd(
  X,
  Y,
  copula_family,
  start_copula,
  method = "BFGS",
  K_X,
  K_Y,
  names_XY = c("Surr", "True"),
  twostep = FALSE,
  ...
)
}
\arguments{
\item{X}{First variable (Ordinal with \eqn{K_X} categories)}

\item{Y}{Second variable (Ordinal with \eqn{K_Y} categories)}

\item{copula_family}{Copula family, one of the following:
\itemize{
\item \code{"clayton"}
\item \code{"frank"}
\item \code{"gumbel"}
\item \code{"gaussian"}
}}

\item{start_copula}{Starting value for the copula parameter.}

\item{method}{Optimization algorithm for maximizing the objective function.
For all options, see \code{?maxLik::maxLik}. Defaults to \code{"BFGS"}.}

\item{K_X}{Number of categories in \code{X}.}

\item{K_Y}{Number of categories in \code{Y}.}

\item{names_XY}{Names for \code{X} and \code{Y}, respectively.}

\item{twostep}{(boolean) If \code{TRUE}, the starting values are fixed for the
marginal distributions and only the copula parameter is estimated.}

\item{...}{Extra argument to pass onto maxLik::maxLik}
}
\value{
A list with five elements:
\itemize{
\item ml_fit: object of class \code{maxLik::maxLik} that contains the estimated copula
model.
\item marginal_X: list with the estimated cdf, pdf/pmf, and inverse cdf for X.
\item marginal_Y: list with the estimated cdf, pdf/pmf, and inverse cdf for X.
\item copula_family: string that indicates the copula family
\item data: data frame containing \code{X} and \code{Y}
\item names_XY: The names (i.e., \code{"Surr"} and \code{"True"}) for \code{X} and \code{Y}
}
}
\description{
The \code{fit_copula_submodel_OrdOrd()} function fits the copula (sub)model for an
ordinal surrogate and true endpoint with maximum likelihood.
}
